/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.duraspace.bagit.BagItDigest;
import org.duraspace.bagit.HexEncoder;

public class BagWriter {
    private File bagDir;
    private File dataDir;
    private Set<String> algorithms;
    private Map<String, Map<File, String>> payloadRegistry;
    private Map<String, Map<File, String>> tagFileRegistry;
    private Map<String, Map<String, String>> tagRegistry;
    public static String BAGIT_VERSION = "0.97";

    public BagWriter(File bagDir, Set<String> algorithms) {
        this.bagDir = bagDir;
        this.dataDir = new File(bagDir, "data");
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        this.algorithms = algorithms;
        this.payloadRegistry = new HashMap<String, Map<File, String>>();
        this.tagFileRegistry = new HashMap<String, Map<File, String>>();
        this.tagRegistry = new HashMap<String, Map<String, String>>();
        HashMap<String, String> bagitValues = new HashMap<String, String>();
        bagitValues.put("BagIt-Version", BAGIT_VERSION);
        bagitValues.put("Tag-File-Character-Encoding", "UTF-8");
        this.tagRegistry.put("bagit.txt", bagitValues);
    }

    public File getRootDir() {
        return this.bagDir;
    }

    public void registerChecksums(String algorithm, Map<File, String> filemap) {
        if (!this.algorithms.contains(algorithm)) {
            throw new RuntimeException("Invalid algorithm: " + algorithm);
        }
        this.payloadRegistry.put(algorithm, filemap);
    }

    public void addTags(String key, Map<String, String> values) {
        this.tagRegistry.put(key, values);
    }

    public Map<String, String> getTags(String key) {
        return this.tagRegistry.get(key);
    }

    public void write() throws IOException {
        this.writeManifests("manifest", this.payloadRegistry);
        for (String tagFile : this.tagRegistry.keySet()) {
            this.writeTagFile(tagFile);
        }
        this.writeManifests("tagmanifest", this.tagFileRegistry);
    }

    private void writeManifests(String prefix, Map<String, Map<File, String>> registry) throws IOException {
        String delimiter = "  ";
        int backslash = 92;
        int bagitSeparator = 47;
        Path bag = this.bagDir.toPath();
        for (String algorithm : this.algorithms) {
            Map<File, String> filemap = registry.get(algorithm);
            if (filemap == null) continue;
            File f = new File(this.bagDir, prefix + "-" + algorithm + ".txt");
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            Throwable throwable = null;
            try {
                for (File payload : filemap.keySet()) {
                    String relative = bag.relativize(payload.toPath()).toString().replace('\\', '/');
                    out.println(filemap.get(payload) + "  " + relative);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void writeTagFile(String key) throws IOException {
        Map<String, String> values = this.tagRegistry.get(key);
        if (values != null) {
            File f = new File(this.bagDir, key);
            MessageDigest md5 = null;
            MessageDigest sha1 = null;
            MessageDigest sha256 = null;
            MessageDigest sha512 = null;
            if (this.algorithms.contains(BagItDigest.MD5.bagitName())) {
                md5 = BagItDigest.MD5.messageDigest();
            }
            if (this.algorithms.contains(BagItDigest.SHA1.bagitName())) {
                sha1 = BagItDigest.SHA1.messageDigest();
            }
            if (this.algorithms.contains(BagItDigest.SHA256.bagitName())) {
                sha256 = BagItDigest.SHA256.messageDigest();
            }
            if (this.algorithms.contains(BagItDigest.SHA512.bagitName())) {
                sha512 = BagItDigest.SHA512.messageDigest();
            }
            try (FileOutputStream out = new FileOutputStream(f);){
                for (String field : values.keySet()) {
                    byte[] bytes = (field + ": " + values.get(field) + "\n").getBytes();
                    ((OutputStream)out).write(bytes);
                    if (md5 != null) {
                        md5.update(bytes);
                    }
                    if (sha1 != null) {
                        sha1.update(bytes);
                    }
                    if (sha256 != null) {
                        sha256.update(bytes);
                    }
                    if (sha512 == null) continue;
                    sha512.update(bytes);
                }
            }
            this.addTagChecksum(BagItDigest.MD5.bagitName(), f, md5);
            this.addTagChecksum(BagItDigest.SHA1.bagitName(), f, sha1);
            this.addTagChecksum(BagItDigest.SHA256.bagitName(), f, sha256);
            this.addTagChecksum(BagItDigest.SHA512.bagitName(), f, sha512);
        }
    }

    private void addTagChecksum(String algorithm, File f, MessageDigest digest) {
        if (digest != null) {
            Map m = this.tagFileRegistry.computeIfAbsent(algorithm, key -> new HashMap());
            m.put(f, HexEncoder.toString(digest.digest()));
        }
    }
}

