/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import gov.loc.repository.bagit.domain.Manifest;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.duraspace.bagit.ProfileFieldRule;
import org.duraspace.bagit.ProfileValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileValidationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProfileValidationUtil.class);
    protected static final Set<String> SYSTEM_GENERATED_FIELD_NAMES = new HashSet<String>(Arrays.asList("Bagging-Date", "Bag-Size", "Bag-Count", "Payload-Oxum", "BagIt-Profile-Identifier"));

    private ProfileValidationUtil() {
    }

    public static void validate(String profileSection, Map<String, ProfileFieldRule> requiredFields, Path tag) throws ProfileValidationException, IOException {
        Map<String, String> fields = ProfileValidationUtil.readInfo(tag);
        ProfileValidationUtil.validate(profileSection, requiredFields, fields, Collections.emptySet());
    }

    public static void validate(String profileSection, Map<String, ProfileFieldRule> requiredFields, Map<String, String> fields) throws ProfileValidationException {
        ProfileValidationUtil.validate(profileSection, requiredFields, fields, SYSTEM_GENERATED_FIELD_NAMES);
    }

    private static void validate(String profileSection, Map<String, ProfileFieldRule> requiredFields, Map<String, String> fields, Set<String> filter) throws ProfileValidationException {
        if (requiredFields != null) {
            StringBuilder errors = new StringBuilder();
            for (String requiredField : requiredFields.keySet()) {
                if (filter.contains(requiredField)) {
                    logger.debug("skipping system generated field {}...", (Object)requiredField);
                    continue;
                }
                ProfileFieldRule rule = requiredFields.get(requiredField);
                if (fields.containsKey(requiredField)) {
                    String value = fields.get(requiredField);
                    Set<String> validValues = rule.getValues();
                    if (validValues == null || validValues.isEmpty() || validValues.contains(value)) continue;
                    String invalidMessage = "\"%s\" is not valid for \"%s\". Valid values: %s\n";
                    errors.append(String.format("\"%s\" is not valid for \"%s\". Valid values: %s\n", value, requiredField, validValues));
                    continue;
                }
                if (rule.isRequired()) {
                    errors.append("\"" + requiredField + "\" is a required field.\n");
                    continue;
                }
                if (!rule.isRecommended()) continue;
                logger.warn("{} does not contain the recommended field {}", (Object)profileSection, (Object)requiredField);
            }
            if (errors.length() > 0) {
                throw new ProfileValidationException("Bag profile validation failure: The following errors occurred in the " + profileSection + ":\n" + errors.toString());
            }
        }
    }

    public static String validateManifest(Set<Manifest> manifests, Set<String> required, Set<String> allowed, String type) {
        String missing = "Missing %s manifest algorithm: %s\n";
        String unsupported = "Unsupported %s manifest algorithm: %s\n";
        StringBuilder errors = new StringBuilder();
        HashSet<String> requiredCopy = new HashSet<String>(required);
        for (Manifest manifest : manifests) {
            String algorithm = manifest.getAlgorithm().getBagitName();
            requiredCopy.remove(algorithm);
            if (allowed.isEmpty() || allowed.contains(algorithm)) continue;
            errors.append(String.format("Unsupported %s manifest algorithm: %s\n", type, algorithm));
        }
        if (!requiredCopy.isEmpty()) {
            errors.append(String.format("Missing %s manifest algorithm: %s\n", type, required));
        }
        return errors.toString();
    }

    public static void validateTagIsAllowed(Path tag, Set<String> allowedTags) throws ProfileValidationException {
        if (tag != null && allowedTags != null && !allowedTags.isEmpty()) {
            String systemFiles = "bagit\\.txt|bag-info\\.txt|manifest-.*|tagmanifest-.*";
            if (Pattern.matches("bagit\\.txt|bag-info\\.txt|manifest-.*|tagmanifest-.*", tag.toString())) {
                logger.debug("Tag validator used against required file {}; ignoring", (Object)tag);
                return;
            }
            boolean match = false;
            for (String allowedTag : allowedTags) {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + allowedTag);
                if (!matcher.matches(tag)) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new ProfileValidationException("Bag profile validation failure: tag " + tag + " is not allowed. List of allowed tag files are " + allowedTags);
            }
        }
    }

    private static Map<String, String> readInfo(Path info) throws IOException {
        logger.debug("Trying to read info file {}", (Object)info);
        HashMap<String, String> data = new HashMap<String, String>();
        AtomicReference<String> previousKey = new AtomicReference<String>("");
        try (Stream<String> lines = Files.lines(info);){
            lines.forEach(line -> {
                if (line.matches("^\\s+")) {
                    data.merge((String)previousKey.get(), (String)line, String::concat);
                } else {
                    String[] split = line.split(":");
                    String key = split[0].trim();
                    String value = split[1].trim();
                    previousKey.set(key);
                    data.put(key, value);
                }
            });
        }
        return data;
    }
}

