/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.duraspace.bagit.BagDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarBagDeserializer
implements BagDeserializer {
    private final Logger logger = LoggerFactory.getLogger(TarBagDeserializer.class);

    protected TarBagDeserializer() {
    }

    @Override
    public Path deserialize(Path root) throws IOException {
        this.logger.info("Extracting serialized bag: {}", (Object)root.getFileName());
        Path parent = root.getParent();
        int rootPathCount = root.getNameCount();
        Optional<String> filename = Optional.empty();
        try (TarArchiveInputStream tais = new TarArchiveInputStream(Files.newInputStream(root, new OpenOption[0]));){
            ArchiveEntry entry;
            while ((entry = tais.getNextEntry()) != null) {
                String name = entry.getName();
                this.logger.debug("Handling entry {}", (Object)entry.getName());
                Path archiveFile = parent.resolve(name);
                if (Files.notExists(archiveFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(archiveFile.getParent(), new FileAttribute[0]);
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(archiveFile, new FileAttribute[0]);
                    if (archiveFile.getNameCount() != rootPathCount) continue;
                    this.logger.debug("Archive name is {}", (Object)archiveFile.getFileName());
                    filename = Optional.of(archiveFile.getFileName().toString());
                    continue;
                }
                if (Files.exists(parent.resolve(name), new LinkOption[0])) {
                    this.logger.warn("File {} already exists!", (Object)name);
                    continue;
                }
                Files.copy((InputStream)tais, archiveFile, new CopyOption[0]);
            }
        }
        String extracted = filename.orElseGet(() -> {
            String rootName = root.getFileName().toString();
            int dotIdx = rootName.lastIndexOf(".");
            return rootName.substring(0, dotIdx);
        });
        return parent.resolve(extracted);
    }
}

