/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.duraspace.bagit.BagSerializer;

public class ZipBagSerializer
implements BagSerializer {
    private final String extension = ".zip";

    @Override
    public Path serialize(Path root) throws IOException {
        Path parent = root.getParent().toAbsolutePath();
        String bagName = root.getFileName().toString();
        Path serializedBag = parent.resolve(bagName + ".zip");
        try (OutputStream os = Files.newOutputStream(serializedBag, new OpenOption[0]);
             ZipArchiveOutputStream zip = new ZipArchiveOutputStream(os);){
            List files = Files.walk(root, new FileVisitOption[0]).collect(Collectors.toList());
            for (Path bagEntry : files) {
                String name = parent.relativize(bagEntry).toString();
                ArchiveEntry entry = zip.createArchiveEntry(bagEntry.toFile(), name);
                zip.putArchiveEntry(entry);
                if (bagEntry.toFile().isFile()) {
                    try (InputStream inputStream = Files.newInputStream(bagEntry, new OpenOption[0]);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)zip);
                    }
                }
                zip.closeArchiveEntry();
            }
        }
        return serializedBag;
    }
}

