/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.duraspace.bagit.BagItDigest;
import org.duraspace.bagit.HexEncoder;

public class BagWriter {
    private File bagDir;
    private File dataDir;
    private Set<BagItDigest> algorithms;
    private Map<BagItDigest, Map<File, String>> payloadRegistry;
    private Map<BagItDigest, Map<File, String>> tagFileRegistry;
    private Map<String, Map<String, String>> tagRegistry;
    private Map<BagItDigest, DigestOutputStream> activeStreams;
    public static String BAGIT_VERSION = "1.0";

    public BagWriter(File bagDir, Set<BagItDigest> algorithms) {
        this.bagDir = bagDir;
        this.dataDir = new File(bagDir, "data");
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        this.algorithms = algorithms;
        this.payloadRegistry = new HashMap<BagItDigest, Map<File, String>>();
        this.tagFileRegistry = new HashMap<BagItDigest, Map<File, String>>();
        this.tagRegistry = new HashMap<String, Map<String, String>>();
        TreeMap<String, String> bagitValues = new TreeMap<String, String>();
        bagitValues.put("BagIt-Version", BAGIT_VERSION);
        bagitValues.put("Tag-File-Character-Encoding", "UTF-8");
        this.tagRegistry.put("bagit.txt", bagitValues);
        this.activeStreams = new HashMap<BagItDigest, DigestOutputStream>();
    }

    public File getRootDir() {
        return this.bagDir;
    }

    public void registerChecksums(BagItDigest algorithm, Map<File, String> filemap) {
        if (!this.algorithms.contains((Object)algorithm)) {
            throw new RuntimeException("Invalid algorithm: " + (Object)((Object)algorithm));
        }
        this.payloadRegistry.put(algorithm, filemap);
    }

    public void addTags(String key, Map<String, String> values) {
        Map tagValues = this.tagRegistry.computeIfAbsent(key, k -> new HashMap());
        tagValues.putAll(values);
    }

    public Map<String, String> getTags(String key) {
        return this.tagRegistry.get(key);
    }

    public void write() throws IOException {
        this.writeManifests("manifest", this.payloadRegistry, true);
        for (String tagFile : this.tagRegistry.keySet()) {
            this.writeTagFile(tagFile);
        }
        this.writeManifests("tagmanifest", this.tagFileRegistry, false);
    }

    private void writeManifests(String prefix, Map<BagItDigest, Map<File, String>> registry, boolean registerToTags) throws IOException {
        String delimiter = "  ";
        int backslash = 92;
        int bagitSeparator = 47;
        Path bag = this.bagDir.toPath();
        for (BagItDigest algorithm : this.algorithms) {
            Map<File, String> filemap = registry.get((Object)algorithm);
            if (filemap == null) continue;
            File manifest = new File(this.bagDir, prefix + "-" + algorithm.bagitName() + ".txt");
            try (OutputStream out = this.streamFor(manifest.toPath());){
                for (File payload : filemap.keySet()) {
                    String relative = bag.relativize(payload.toPath()).toString().replace('\\', '/');
                    String line = filemap.get(payload) + "  " + relative;
                    out.write(line.getBytes());
                    out.write("\n".getBytes());
                }
            }
            if (registerToTags) {
                for (Map.Entry<BagItDigest, DigestOutputStream> entry : this.activeStreams.entrySet()) {
                    this.addTagChecksum(entry.getKey(), manifest, entry.getValue().getMessageDigest());
                }
            }
            this.activeStreams.clear();
        }
    }

    private void writeTagFile(String key) throws IOException {
        Map<String, String> values = this.tagRegistry.get(key);
        if (values != null) {
            File f = new File(this.bagDir, key);
            try (OutputStream out = this.streamFor(f.toPath());){
                for (String field : values.keySet()) {
                    byte[] bytes = (field + ": " + values.get(field) + "\n").getBytes();
                    out.write(bytes);
                }
            }
            for (Map.Entry<BagItDigest, DigestOutputStream> entry : this.activeStreams.entrySet()) {
                this.addTagChecksum(entry.getKey(), f, entry.getValue().getMessageDigest());
            }
        }
        this.activeStreams.clear();
    }

    private OutputStream streamFor(Path file) throws IOException {
        OutputStream lastStream = Files.newOutputStream(file, new OpenOption[0]);
        for (BagItDigest algorithm : this.algorithms) {
            DigestOutputStream dos = new DigestOutputStream(lastStream, algorithm.messageDigest());
            this.activeStreams.put(algorithm, dos);
            lastStream = dos;
        }
        return lastStream;
    }

    private void addTagChecksum(BagItDigest algorithm, File f, MessageDigest digest) {
        if (digest != null) {
            Map m = this.tagFileRegistry.computeIfAbsent(algorithm, key -> new HashMap());
            m.put(f, HexEncoder.toString(digest.digest()));
        }
    }
}

