/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.duraspace.bagit.BagDeserializer;
import org.duraspace.bagit.BagProfile;
import org.duraspace.bagit.SerializationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipBagDeserializer
implements BagDeserializer {
    private final Logger logger = LoggerFactory.getLogger(GZipBagDeserializer.class);
    private final BagProfile profile;

    protected GZipBagDeserializer(BagProfile profile) {
        this.profile = profile;
    }

    @Override
    public Path deserialize(Path root) throws IOException {
        Path parent = root.getParent();
        String nameWithExtension = root.getFileName().toString();
        int dotIdx = nameWithExtension.lastIndexOf(".");
        String filename = dotIdx == -1 ? nameWithExtension : nameWithExtension.substring(0, dotIdx);
        Path serializedBag = parent.resolve(filename);
        this.logger.info("Deflating gzipped bag: {}", (Object)filename);
        try (InputStream is = Files.newInputStream(root, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);
             GzipCompressorInputStream gzipIS = new GzipCompressorInputStream((InputStream)bis);){
            Files.copy((InputStream)gzipIS, serializedBag, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException ex) {
            this.logger.warn("{} already decompressed! Continuing with deserialization.", (Object)root);
        }
        BagDeserializer deserializer = SerializationSupport.deserializerFor(serializedBag, this.profile);
        return deserializer.deserialize(serializedBag);
    }
}

