/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tika.Tika;
import org.duraspace.bagit.BagDeserializer;
import org.duraspace.bagit.BagProfile;
import org.duraspace.bagit.BagSerializer;
import org.duraspace.bagit.GZipBagDeserializer;
import org.duraspace.bagit.TarBagDeserializer;
import org.duraspace.bagit.TarBagSerializer;
import org.duraspace.bagit.TarGzBagSerializer;
import org.duraspace.bagit.ZipBagDeserializer;
import org.duraspace.bagit.ZipBagSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationSupport {
    private static final Logger logger = LoggerFactory.getLogger(SerializationSupport.class);
    protected static final String APPLICATION_ZIP = "application/zip";
    protected static final String APPLICATION_TAR = "application/tar";
    protected static final String APPLICATION_GTAR = "application/gtar";
    protected static final String APPLICATION_X_TAR = "application/x-tar";
    protected static final String APPLICATION_X_GTAR = "application/x-gtar";
    protected static final String APPLICATION_GZIP = "application/gzip";
    protected static final String APPLICATION_X_GZIP = "application/x-gzip";
    protected static final String APPLICATION_X_COMPRESSED_TAR = "application/x-compressed-tar";
    public static final Set<String> ZIP_TYPES = Collections.singleton("application/zip");
    public static final Set<String> TAR_TYPES = new HashSet<String>(Arrays.asList("application/tar", "application/x-tar", "application/gtar", "application/x-gtar"));
    public static final Set<String> GZIP_TYPES = new HashSet<String>(Arrays.asList("application/gzip", "application/x-gtar", "application/x-compressed-tar"));
    private static Map<String, String> commonTypeMap = SerializationSupport.initCommonTypeMapping();

    private SerializationSupport() {
    }

    private static Map<String, String> initCommonTypeMapping() {
        commonTypeMap = new HashMap<String, String>();
        commonTypeMap.put("zip", APPLICATION_ZIP);
        commonTypeMap.put(APPLICATION_ZIP, APPLICATION_ZIP);
        commonTypeMap.put("tar", APPLICATION_TAR);
        commonTypeMap.put(APPLICATION_TAR, APPLICATION_TAR);
        commonTypeMap.put(APPLICATION_GTAR, APPLICATION_TAR);
        commonTypeMap.put(APPLICATION_X_TAR, APPLICATION_TAR);
        commonTypeMap.put(APPLICATION_X_GTAR, APPLICATION_TAR);
        commonTypeMap.put("tgz", APPLICATION_GZIP);
        commonTypeMap.put("gzip", APPLICATION_GZIP);
        commonTypeMap.put("tar+gz", APPLICATION_GZIP);
        commonTypeMap.put(APPLICATION_GZIP, APPLICATION_GZIP);
        commonTypeMap.put(APPLICATION_X_GZIP, APPLICATION_GZIP);
        commonTypeMap.put(APPLICATION_X_COMPRESSED_TAR, APPLICATION_GZIP);
        return commonTypeMap;
    }

    protected static Map<String, String> getCommonTypeMap() {
        return new HashMap<String, String>(commonTypeMap);
    }

    public static BagDeserializer deserializerFor(Path serializedBag, BagProfile profile) {
        String contentType;
        Tika tika = new Tika();
        try {
            String detectedType = tika.detect(serializedBag);
            contentType = commonTypeMap.getOrDefault(detectedType, detectedType);
            logger.debug("{}: {}", (Object)serializedBag, (Object)contentType);
        }
        catch (IOException e) {
            logger.error("Unable to get content type for {}", (Object)serializedBag);
            throw new RuntimeException(e);
        }
        if (profile.getAcceptedSerializations().contains(contentType)) {
            if (ZIP_TYPES.contains(contentType)) {
                return new ZipBagDeserializer();
            }
            if (TAR_TYPES.contains(contentType)) {
                return new TarBagDeserializer();
            }
            if (GZIP_TYPES.contains(contentType)) {
                return new GZipBagDeserializer(profile);
            }
            throw new UnsupportedOperationException("Unsupported content type " + contentType);
        }
        throw new RuntimeException("BagProfile does not allow " + contentType + ". Accepted serializations are:\n" + profile.getAcceptedSerializations());
    }

    public static BagSerializer serializerFor(String contentType, BagProfile profile) {
        String type = commonTypeMap.getOrDefault(contentType, contentType);
        if (profile.getAcceptedSerializations().contains(type)) {
            if (ZIP_TYPES.contains(type)) {
                return new ZipBagSerializer();
            }
            if (TAR_TYPES.contains(type)) {
                return new TarBagSerializer();
            }
            if (GZIP_TYPES.contains(type)) {
                return new TarGzBagSerializer();
            }
            throw new UnsupportedOperationException("Unsupported content type " + contentType);
        }
        throw new RuntimeException("BagProfile does not allow " + type + ". Accepted serializations are:\n" + profile.getAcceptedSerializations());
    }
}

