/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.duraspace.bagit.BagSerializer;

public class TarGzBagSerializer
implements BagSerializer {
    private final String extension = ".tar.gz";

    @Override
    public Path serialize(Path root) throws IOException {
        Path parent = root.getParent().toAbsolutePath();
        String bagName = root.getFileName().toString();
        Path serializedBag = parent.resolve(bagName + ".tar.gz");
        try (OutputStream os = Files.newOutputStream(serializedBag, new OpenOption[0]);
             GZIPOutputStream gzip = new GZIPOutputStream(os);
             TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)gzip);){
            tar.setLongFileMode(3);
            tar.setBigNumberMode(2);
            List files = Files.walk(root, new FileVisitOption[0]).collect(Collectors.toList());
            for (Path bagEntry : files) {
                String name = parent.relativize(bagEntry).toString();
                ArchiveEntry entry = tar.createArchiveEntry(bagEntry.toFile(), name);
                tar.putArchiveEntry(entry);
                if (bagEntry.toFile().isFile()) {
                    try (InputStream inputStream = Files.newInputStream(bagEntry, new OpenOption[0]);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)tar);
                    }
                }
                tar.closeArchiveEntry();
            }
        }
        return serializedBag;
    }
}

