/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.api;

import java.io.InputStream;
import java.util.List;
import org.duraspace.fcrepo.cloudsync.api.AlreadyInitializedException;
import org.duraspace.fcrepo.cloudsync.api.NameConflictException;
import org.duraspace.fcrepo.cloudsync.api.ObjectSet;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.api.ProviderAccount;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.api.ServiceInfo;
import org.duraspace.fcrepo.cloudsync.api.ServiceInit;
import org.duraspace.fcrepo.cloudsync.api.Space;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.api.TaskLog;
import org.duraspace.fcrepo.cloudsync.api.UnauthorizedException;
import org.duraspace.fcrepo.cloudsync.api.User;

public interface CloudSyncService {
    public ServiceInfo getServiceInfo();

    public ServiceInfo initialize(ServiceInit var1) throws AlreadyInitializedException;

    public User createUser(User var1) throws UnauthorizedException, NameConflictException;

    public List<User> listUsers();

    public User getUser(String var1) throws ResourceNotFoundException;

    public User getCurrentUser();

    public User updateUser(String var1, User var2) throws UnauthorizedException, ResourceNotFoundException, NameConflictException;

    public void deleteUser(String var1) throws UnauthorizedException, ResourceInUseException;

    public Task createTask(Task var1) throws NameConflictException;

    public List<Task> listTasks();

    public Task getTask(String var1) throws ResourceNotFoundException;

    public Task updateTask(String var1, Task var2) throws ResourceNotFoundException, NameConflictException;

    public void deleteTask(String var1) throws ResourceInUseException;

    public ObjectSet createObjectSet(ObjectSet var1) throws NameConflictException;

    public List<ObjectSet> listObjectSets();

    public ObjectSet getObjectSet(String var1) throws ResourceNotFoundException;

    public ObjectSet updateObjectSet(String var1, ObjectSet var2) throws ResourceNotFoundException, NameConflictException;

    public void deleteObjectSet(String var1) throws ResourceInUseException;

    public ObjectStore createObjectStore(ObjectStore var1) throws NameConflictException;

    public List<ObjectStore> listObjectStores();

    public ObjectStore getObjectStore(String var1) throws ResourceNotFoundException;

    public void deleteObjectStore(String var1) throws ResourceInUseException;

    public List<TaskLog> listTaskLogs();

    public TaskLog getTaskLog(String var1) throws ResourceNotFoundException;

    public InputStream getTaskLogContent(String var1) throws ResourceNotFoundException;

    public void deleteTaskLog(String var1) throws ResourceInUseException;

    public List<ProviderAccount> listProviderAccounts(String var1, String var2, String var3);

    public List<Space> listSpaces(String var1, String var2, String var3, String var4);
}

