/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class CloudSyncContextListener
implements ServletContextListener {
    private Logger logger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        try {
            Handler[] handlers;
            ServletContext context = sce.getServletContext();
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("cloudsync.properties"));
            for (String name : props.stringPropertyNames()) {
                System.setProperty(name, props.getProperty(name));
            }
            String home = System.getProperty("cloudsync.home");
            if (!(home != null && home.trim().length() != 0 || (home = System.getenv("CLOUDSYNC_HOME")) != null && home.trim().length() != 0)) {
                File userHome = new File(System.getProperty("user.home"));
                home = new File(userHome, ".cloudsync").getPath();
            }
            File homeDir = new File(home);
            System.setProperty("cloudsync.home", homeDir.getPath());
            if (!homeDir.exists() && !homeDir.mkdirs()) {
                throw new IOException("Unable to create CloudSync home directory: " + homeDir.getPath());
            }
            File logbackFile = new File(homeDir, "logback.xml");
            if (!logbackFile.exists()) {
                InputStream in = context.getResourceAsStream("WEB-INF/default-logback.xml");
                FileOutputStream out = new FileOutputStream(logbackFile);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            System.setProperty("logback.configurationFile", logbackFile.getPath());
            java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
            for (Handler handler : handlers = rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
            }
            SLF4JBridgeHandler.install();
            File systemLogDir = new File(homeDir, "systemlogs");
            if (!systemLogDir.isDirectory() && !systemLogDir.mkdir()) {
                throw new IOException("Unable to create CloudSync system log directory: " + systemLogDir.getPath());
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.logger.info("Starting CloudSync. Home directory is " + homeDir.getPath());
            String jdbcDriver = "org.apache.derby.jdbc.EmbeddedDriver";
            File dbDir = new File(homeDir, "database");
            String jdbcURL = "jdbc:derby:" + dbDir.getPath() + ";create=true";
            Class.forName(jdbcDriver).newInstance();
            Connection conn = DriverManager.getConnection(jdbcURL);
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error("Error closing database connection", (Throwable)e);
            }
            System.setProperty("jdbc.driver", jdbcDriver);
            System.setProperty("jdbc.url", jdbcURL);
        }
        catch (Exception e) {
            if (this.logger == null) {
                e.printStackTrace();
                System.out.println("Failed to initialize CloudSync; see above.");
            } else {
                this.logger.error("Failed to initialize CloudSync", (Throwable)e);
            }
            throw new RuntimeException("Failed to initialize CloudSync", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.logger.info("Stopped CloudSync.");
    }
}

