/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service;

import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.duraspace.fcrepo.cloudsync.api.AlreadyInitializedException;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.NameConflictException;
import org.duraspace.fcrepo.cloudsync.api.ObjectSet;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.api.ProviderAccount;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.api.ServiceInfo;
import org.duraspace.fcrepo.cloudsync.api.ServiceInit;
import org.duraspace.fcrepo.cloudsync.api.Space;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.api.TaskLog;
import org.duraspace.fcrepo.cloudsync.api.UnauthorizedException;
import org.duraspace.fcrepo.cloudsync.api.User;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskManager;
import org.duraspace.fcrepo.cloudsync.service.dao.DuraCloudDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectSetDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectStoreDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ServiceInfoDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskLogDao;
import org.duraspace.fcrepo.cloudsync.service.dao.UserDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class CloudSyncServiceImpl
implements CloudSyncService {
    private static final Logger logger = LoggerFactory.getLogger(CloudSyncServiceImpl.class);
    private final JdbcTemplate db;
    private final ServiceInfoDao serviceInfoDao;
    private final UserDao userDao;
    private final TaskDao taskDao;
    private final ObjectSetDao objectSetDao;
    private final ObjectStoreDao objectStoreDao;
    private final TaskLogDao taskLogDao;
    private final DuraCloudDao duraCloudDao;
    private final TaskManager taskManager;

    public CloudSyncServiceImpl(DataSource dataSource, PlatformTransactionManager txMan, HttpClientConfig httpClientConfig) {
        this.db = new JdbcTemplate(dataSource);
        TransactionTemplate tt = new TransactionTemplate(txMan);
        this.userDao = new UserDao(this.db, tt);
        this.serviceInfoDao = new ServiceInfoDao(this.db, this.userDao);
        this.objectSetDao = new ObjectSetDao(this.db);
        this.objectStoreDao = new ObjectStoreDao(this.db);
        this.taskDao = new TaskDao(this.db, tt, this.objectSetDao, this.objectStoreDao);
        this.taskLogDao = new TaskLogDao(this.db);
        this.duraCloudDao = new DuraCloudDao();
        if (this.db.queryForInt("SELECT COUNT(*) FROM sys.systables WHERE tablename = 'CLOUDSYNC'") == 0) {
            this.initDb();
        }
        logger.info("Service startup complete. Ready to handle requests.");
        this.taskManager = new TaskManager(this.taskDao, this.taskLogDao, this.objectSetDao, this.objectStoreDao, httpClientConfig);
        this.taskManager.start();
    }

    @PreDestroy
    public void close() {
        this.taskManager.shutdown();
    }

    private void initDb() {
        logger.info("First run detected. Creating database tables.");
        this.db.execute("create table CloudSync(schemaVersion int)");
        this.db.update("insert into CloudSync values (1)");
        this.serviceInfoDao.initDb();
        this.userDao.initDb();
        this.objectSetDao.initDb();
        this.objectStoreDao.initDb();
        this.taskDao.initDb();
        this.taskLogDao.initDb();
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfoDao.getServiceInfo();
    }

    public ServiceInfo initialize(ServiceInit serviceInit) throws AlreadyInitializedException {
        if (this.getServiceInfo().isInitialized()) {
            throw new AlreadyInitializedException();
        }
        User user = new User();
        user.setAdmin(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        user.setName(serviceInit.getInitialAdminUsername());
        user.setPassword(serviceInit.getInitialAdminPassword());
        try {
            this.userDao.createUser(user);
        }
        catch (UnauthorizedException wontHappen) {
            throw new RuntimeException(wontHappen);
        }
        this.serviceInfoDao.setInitialized();
        return this.getServiceInfo();
    }

    public User createUser(User user) throws UnauthorizedException, NameConflictException {
        try {
            return this.userDao.createUser(user);
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("User name is already in use", (Throwable)e);
        }
    }

    public List<User> listUsers() {
        return this.userDao.listUsers();
    }

    public User getUser(String id) throws ResourceNotFoundException {
        User result = this.userDao.getUser(id);
        if (result == null) {
            throw new ResourceNotFoundException("No such user: " + id);
        }
        return result;
    }

    public User getCurrentUser() {
        return this.userDao.getCurrentUser();
    }

    public User updateUser(String id, User user) throws UnauthorizedException, ResourceNotFoundException, NameConflictException {
        try {
            User result = this.userDao.updateUser(id, user);
            if (result == null) {
                throw new ResourceNotFoundException("No such user: " + id);
            }
            return result;
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("User name is already in use", (Throwable)e);
        }
    }

    public void deleteUser(String id) throws UnauthorizedException, ResourceInUseException {
        if (id.equals(this.getCurrentUser().getId())) {
            throw new ResourceInUseException("You can't delete yourself");
        }
        this.userDao.deleteUser(id);
    }

    public Task createTask(Task task) throws NameConflictException {
        try {
            return this.taskDao.createTask(task);
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("Task name is already in use", (Throwable)e);
        }
    }

    public List<Task> listTasks() {
        return this.taskDao.listTasks();
    }

    public Task getTask(String id) throws ResourceNotFoundException {
        Task result = this.taskDao.getTask(id);
        if (result == null) {
            throw new ResourceNotFoundException("No such task: " + id);
        }
        return result;
    }

    public Task updateTask(String id, Task task) throws ResourceNotFoundException, NameConflictException {
        try {
            Task result = this.taskDao.updateTask(id, task);
            if (result == null) {
                throw new ResourceNotFoundException("No such task: " + id);
            }
            return result;
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("Task name is already in use", (Throwable)e);
        }
    }

    public void deleteTask(String id) throws ResourceInUseException {
        if (this.taskDao.getTask(id).getState().equals("Idle")) {
            try {
                this.taskDao.deleteTask(id);
            }
            catch (DataIntegrityViolationException e) {
                throw new ResourceInUseException("Task cannot be deleted; it is being used by a task log", (Throwable)e);
            }
        } else {
            throw new ResourceInUseException("Task cannot be deleted while active");
        }
    }

    public ObjectSet createObjectSet(ObjectSet objectSet) throws NameConflictException {
        try {
            return this.objectSetDao.createObjectSet(objectSet);
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("Object set name is already in use", (Throwable)e);
        }
    }

    public List<ObjectSet> listObjectSets() {
        return this.objectSetDao.listObjectSets();
    }

    public ObjectSet getObjectSet(String id) throws ResourceNotFoundException {
        ObjectSet result = this.objectSetDao.getObjectSet(id);
        if (result == null) {
            throw new ResourceNotFoundException("No such object set: " + id);
        }
        return result;
    }

    public ObjectSet updateObjectSet(String id, ObjectSet objectSet) throws ResourceNotFoundException, NameConflictException {
        try {
            ObjectSet result = this.objectSetDao.updateObjectSet(id, objectSet);
            if (result == null) {
                throw new ResourceNotFoundException("No such user: " + id);
            }
            return result;
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("Set name is already in use", (Throwable)e);
        }
    }

    public void deleteObjectSet(String id) throws ResourceInUseException {
        try {
            this.objectSetDao.deleteObjectSet(id);
        }
        catch (DataIntegrityViolationException e) {
            throw new ResourceInUseException("Object set is currently being used by a task", (Throwable)e);
        }
    }

    public ObjectStore createObjectStore(ObjectStore objectStore) throws NameConflictException {
        try {
            return this.objectStoreDao.createObjectStore(objectStore);
        }
        catch (DuplicateKeyException e) {
            throw new NameConflictException("Object store name is already in use", (Throwable)e);
        }
    }

    public List<ObjectStore> listObjectStores() {
        return this.objectStoreDao.listObjectStores();
    }

    public ObjectStore getObjectStore(String id) throws ResourceNotFoundException {
        ObjectStore result = this.objectStoreDao.getObjectStore(id);
        if (result == null) {
            throw new ResourceNotFoundException("No such object store: " + id);
        }
        return result;
    }

    public void deleteObjectStore(String id) throws ResourceInUseException {
        try {
            this.objectStoreDao.deleteObjectStore(id);
        }
        catch (DataIntegrityViolationException e) {
            throw new ResourceInUseException("Object store is currently being used by a task", (Throwable)e);
        }
    }

    public List<TaskLog> listTaskLogs() {
        return this.taskLogDao.listTaskLogs();
    }

    public TaskLog getTaskLog(String id) throws ResourceNotFoundException {
        TaskLog result = this.taskLogDao.getTaskLog(id);
        if (result == null) {
            throw new ResourceNotFoundException("No such task log: " + id);
        }
        return result;
    }

    public InputStream getTaskLogContent(String id) throws ResourceNotFoundException {
        try {
            return this.taskLogDao.getTaskLogContent(id);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException("No such task log: " + id, (Throwable)e);
        }
    }

    public void deleteTaskLog(String id) {
        this.taskLogDao.deleteTaskLog(id);
    }

    public List<ProviderAccount> listProviderAccounts(String url, String username, String password) {
        return this.duraCloudDao.listProviderAccounts(url, username, password);
    }

    public List<Space> listSpaces(String url, String username, String password, String providerAccountId) {
        return this.duraCloudDao.listSpaces(url, username, password, providerAccountId);
    }
}

