/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.ControlGroup;
import com.github.cwilper.fcrepo.dto.core.Datastream;
import com.github.cwilper.fcrepo.dto.core.FedoraObject;
import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.duraspace.fcrepo.cloudsync.api.ObjectInfo;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectListHandler;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.duraspace.fcrepo.cloudsync.service.backend.StoreConnector;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCanceledException;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCompletionListener;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskRunner;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectSetDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectStoreDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskDao;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;
import org.duraspace.fcrepo.cloudsync.service.util.JSON;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class CopyTaskRunner
extends TaskRunner
implements ObjectListHandler {
    private final String setId;
    private final String queryStoreId;
    private final String sourceStoreId;
    private final String destStoreId;
    private final boolean overwrite;
    private final boolean includeManaged;
    private final boolean copyExternal;
    private final boolean copyRedirect;
    private final Set<String> relatedSetIds = new HashSet();
    private final Set<String> relatedStoreIds = new HashSet();
    private final HttpClientConfig httpClientConfig;
    private StoreConnector queryConnector;
    private StoreConnector sourceConnector;
    private StoreConnector destConnector;
    private TaskCanceledException canceledException;

    public CopyTaskRunner(Task task, TaskDao taskDao, ObjectSetDao objectSetDao, ObjectStoreDao objectStoreDao, PrintWriter logWriter, TaskCompletionListener completionListener, HttpClientConfig httpClientConfig) {
        super(task, taskDao, objectSetDao, objectStoreDao, logWriter, completionListener);
        Map map = JSON.getMap((JsonNode)JSON.parse((String)task.getData()));
        this.setId = URIMapper.getId((URI)URI.create((String)map.get("setUri")));
        this.queryStoreId = URIMapper.getId((URI)URI.create((String)map.get("queryStoreUri")));
        this.sourceStoreId = URIMapper.getId((URI)URI.create((String)map.get("sourceStoreUri")));
        this.destStoreId = URIMapper.getId((URI)URI.create((String)map.get("destStoreUri")));
        this.overwrite = StringUtil.validate((String)"overwrite", (String)((String)map.get("overwrite")), (String[])new String[]{"true", "false"}).equals("true");
        this.includeManaged = StringUtil.validate((String)"includeManaged", (String)((String)map.get("includeManaged")), (String[])new String[]{"true", "false"}).equals("true");
        this.copyExternal = StringUtil.validate((String)"copyExternal", (String)((String)map.get("copyExternal")), (String[])new String[]{"true", "false"}).equals("true");
        this.copyRedirect = StringUtil.validate((String)"copyRedirect", (String)((String)map.get("copyRedirect")), (String[])new String[]{"true", "false"}).equals("true");
        this.relatedSetIds.add(this.setId);
        this.relatedStoreIds.add(this.queryStoreId);
        this.relatedStoreIds.add(this.sourceStoreId);
        this.relatedStoreIds.add(this.destStoreId);
        this.httpClientConfig = httpClientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() throws Exception {
        this.queryConnector = StoreConnector.getInstance((ObjectStore)this.objectStoreDao.getObjectStore(this.queryStoreId), (HttpClientConfig)this.httpClientConfig);
        this.sourceConnector = StoreConnector.getInstance((ObjectStore)this.objectStoreDao.getObjectStore(this.sourceStoreId), (HttpClientConfig)this.httpClientConfig);
        this.destConnector = StoreConnector.getInstance((ObjectStore)this.objectStoreDao.getObjectStore(this.destStoreId), (HttpClientConfig)this.httpClientConfig);
        try {
            ObjectQuery query = new ObjectQuery(this.objectSetDao.getObjectSet(this.setId));
            this.queryConnector.listObjects(query, (ObjectListHandler)this);
            if (this.canceledException != null) {
                throw this.canceledException;
            }
        }
        finally {
            this.queryConnector.close();
            this.sourceConnector.close();
            this.destConnector.close();
        }
    }

    public Set<String> getRelatedSetIds() {
        return this.relatedSetIds;
    }

    public Set<String> getRelatedStoreIds() {
        return this.relatedStoreIds;
    }

    public boolean handleObject(ObjectInfo info) {
        this.logWriter.print("Copying " + info.getPid() + "..");
        try {
            this.pauseOrCancelIfRequested();
            this.doCopy(info.getPid());
            this.pauseOrCancelIfRequested();
            return true;
        }
        catch (TaskCanceledException e) {
            this.canceledException = e;
            return false;
        }
    }

    private void doCopy(String pid) {
        FedoraObject o = this.sourceConnector.getObject(pid);
        if (o != null) {
            if (!this.includeManaged && CopyTaskRunner.countManagedDatastreams((FedoraObject)o) > 0) {
                this.logWriter.println("SKIPPED (has managed datastream(s))");
            } else {
                boolean existed = this.destConnector.putObject(o, this.sourceConnector, this.overwrite, this.copyExternal, this.copyRedirect);
                if (existed) {
                    if (this.overwrite) {
                        this.logWriter.println("REPLACED (exists in destination)");
                    } else {
                        this.logWriter.println("SKIPPED (exists in destination)");
                    }
                } else {
                    this.logWriter.println("OK (new in destination)");
                }
            }
        } else {
            this.logWriter.println("SKIPPED (does not exist in source)");
        }
    }

    private static int countManagedDatastreams(FedoraObject o) {
        int count = 0;
        for (Datastream ds : o.datastreams().values()) {
            if (!ds.controlGroup().equals((Object)ControlGroup.MANAGED)) continue;
            ++count;
        }
        return count;
    }
}

