/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.ControlGroup;
import com.github.cwilper.fcrepo.dto.core.Datastream;
import com.github.cwilper.fcrepo.dto.core.DatastreamVersion;
import com.github.cwilper.fcrepo.dto.core.FedoraObject;
import com.github.cwilper.fcrepo.dto.foxml.FOXMLReader;
import com.github.cwilper.fcrepo.dto.foxml.FOXMLWriter;
import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import com.github.cwilper.fcrepo.httpclient.MultiThreadedHttpClient;
import com.github.cwilper.ttff.Filter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.codehaus.jackson.JsonNode;
import org.duraspace.fcrepo.cloudsync.api.ObjectInfo;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectListHandler;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.duraspace.fcrepo.cloudsync.service.backend.PIDPatternFilter;
import org.duraspace.fcrepo.cloudsync.service.backend.StoreConnector;
import org.duraspace.fcrepo.cloudsync.service.util.JSON;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DuraCloudConnector
extends StoreConnector {
    private static final int CHUNKSIZE = 999;
    private static final Logger logger = LoggerFactory.getLogger(DuraCloudConnector.class);
    private final URI spaceURI;
    private final String providerId;
    private final String prefix;
    private final MultiThreadedHttpClient httpClient;

    public DuraCloudConnector(ObjectStore store, HttpClientConfig httpClientConfig) {
        Map map = JSON.getMap((JsonNode)JSON.parse((String)store.getData()));
        this.providerId = StringUtil.validate((String)"providerId", (String)((String)map.get("providerId")));
        this.prefix = StringUtil.normalize((String)((String)map.get("prefix")));
        String duraStoreUrl = StringUtil.validate((String)"url", (String)((String)map.get("url")));
        while (duraStoreUrl.endsWith("/")) {
            duraStoreUrl = duraStoreUrl.substring(0, duraStoreUrl.length() - 1);
        }
        String space = StringUtil.validate((String)"space", (String)((String)map.get("space")));
        this.spaceURI = URI.create(duraStoreUrl + "/" + space);
        int port = this.spaceURI.getPort();
        if (port <= 0) {
            port = this.spaceURI.getScheme().equals("http") ? 80 : 443;
        }
        this.httpClient = new MultiThreadedHttpClient(httpClientConfig);
        String username = StringUtil.validate((String)"username", (String)((String)map.get("username")));
        String password = StringUtil.validate((String)"password", (String)((String)map.get("password")));
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.spaceURI.getHost(), port), (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public void listObjects(ObjectQuery query, ObjectListHandler handler) {
        String type = query.getType();
        if (type.equals("pidPattern")) {
            this.listObjects((Filter)new PIDPatternFilter(query.getPidPattern()), handler);
        } else if (type.equals("pidList")) {
            this.listObjects(query.getPidList().iterator(), handler);
        } else {
            throw new UnsupportedOperationException("DuraCloud does not support " + query.getQueryType() + " queries.");
        }
    }

    protected boolean hasObject(String pid) {
        return this.headCheck((HttpClient)this.httpClient, this.getContentURI(pid));
    }

    public FedoraObject getObject(String pid) {
        InputStream in = this.getStream((HttpClient)this.httpClient, this.getContentURI(pid));
        if (in == null) {
            return null;
        }
        try {
            return new FOXMLReader().readObject(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean putObject(FedoraObject o, StoreConnector source, boolean overwrite, boolean copyExternal, boolean copyRedirect) {
        boolean i$;
        boolean existed = this.hasObject(o.pid());
        if (existed && !overwrite) {
            return existed;
        }
        FOXMLWriter writer = new FOXMLWriter();
        File tempFile = null;
        FileOutputStream out = null;
        try {
            for (Datastream ds : o.datastreams().values()) {
                ControlGroup c = ds.controlGroup();
                if ((!c.equals((Object)ControlGroup.EXTERNAL) || !copyExternal) && (!c.equals((Object)ControlGroup.REDIRECT) || !copyRedirect)) continue;
                ds.controlGroup(ControlGroup.MANAGED);
            }
            tempFile = File.createTempFile("cloudsync", null);
            out = new FileOutputStream(tempFile);
            writer.writeObject(o, (OutputStream)out);
            ((OutputStream)out).close();
            this.putObject(o, source, tempFile);
            i$ = existed;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                if (tempFile != null) {
                    tempFile.delete();
                }
                writer.close();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        if (tempFile != null) {
            tempFile.delete();
        }
        writer.close();
        return i$;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putObject(FedoraObject o, StoreConnector source, File foxmlFile) throws IOException {
        boolean success = false;
        HashSet<String> uris = new HashSet<String>();
        try {
            String oURI = this.getContentURI(o.pid());
            uris.add(oURI);
            this.put((HttpClient)this.httpClient, oURI, foxmlFile, "application/xml");
            for (Datastream ds : o.datastreams().values()) {
                if (!ds.controlGroup().equals((Object)ControlGroup.MANAGED)) continue;
                this.putVersions(o, ds, source, uris);
            }
            success = true;
        }
        finally {
            if (!success) {
                logger.info("Cleaning up after failure to put {}", (Object)o.pid());
                for (String uri : uris) {
                    try {
                        this.delete((HttpClient)this.httpClient, uri);
                    }
                    catch (Exception e) {
                        logger.warn("Error cleaning up " + uri, (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putVersions(FedoraObject o, Datastream ds, StoreConnector source, Set<String> urls) throws IOException {
        for (DatastreamVersion dsv : ds.versions()) {
            InputStream in = source.getContent(o, ds, dsv);
            File tempFile = File.createTempFile("cloudsync", null);
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                String url = this.getContentURI(o.pid() + "+" + ds.id() + "+" + dsv.id());
                this.put((HttpClient)this.httpClient, url, tempFile, dsv.mimeType());
                urls.add(url);
            }
            finally {
                if (tempFile.delete()) continue;
                logger.warn("Failed to delete temporary file {}", (Object)tempFile);
            }
        }
    }

    private String getContentURI(String contentId) {
        StringBuilder s = new StringBuilder();
        s.append(this.spaceURI.toString());
        s.append('/');
        if (this.prefix != null) {
            s.append(this.prefix);
        }
        s.append(contentId);
        s.append("?storeID=");
        s.append(this.providerId);
        return s.toString();
    }

    public InputStream getContent(FedoraObject o, Datastream ds, DatastreamVersion dsv) {
        String url = this.getContentURI(o.pid() + "+" + ds.id() + "+" + dsv.id());
        return this.getStream((HttpClient)this.httpClient, url);
    }

    public void close() {
        this.httpClient.close();
    }

    private void listObjects(Filter<String> filter, ObjectListHandler handler) {
        boolean keepGoing = true;
        boolean moreChunks = true;
        String marker = null;
        while (moreChunks && keepGoing) {
            String lastItemId = null;
            int chunkSize = 0;
            for (String itemId : this.getNextChunk(marker, 999)) {
                String pid = this.prefix == null ? itemId : itemId.substring(this.prefix.length());
                try {
                    if (filter.accept((Object)pid) != null) {
                        ObjectInfo o = new ObjectInfo();
                        o.setPid(pid);
                        keepGoing = handler.handleObject(o);
                    }
                }
                catch (IOException wontHappen) {
                    throw new RuntimeException(wontHappen);
                }
                lastItemId = itemId;
                ++chunkSize;
            }
            if (chunkSize == 999) {
                marker = lastItemId;
                continue;
            }
            moreChunks = false;
        }
    }

    private List<String> getNextChunk(String marker, int maxResults) {
        String url = this.spaceURI.toString() + "?storeID=" + this.providerId + "&maxResults=" + maxResults;
        if (marker != null) {
            url = url + "&marker=" + marker;
        }
        if (this.prefix != null) {
            url = url + "&prefix=" + this.prefix;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            Document doc = DuraCloudConnector.parseXML((String)this.getString((HttpClient)this.httpClient, url));
            Element root = doc.getDocumentElement();
            NodeList itemNodes = root.getChildNodes();
            for (int i = 0; i < itemNodes.getLength(); ++i) {
                Node itemNode = itemNodes.item(i);
                if (itemNode.getNodeType() != 1) continue;
                list.add(itemNode.getTextContent().trim());
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Document parseXML(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        InputSource inStream = new InputSource();
        inStream.setCharacterStream(new StringReader(xmlString));
        return db.parse(inStream);
    }
}

