/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.ControlGroup;
import com.github.cwilper.fcrepo.dto.core.Datastream;
import com.github.cwilper.fcrepo.dto.core.DatastreamVersion;
import com.github.cwilper.fcrepo.dto.core.FedoraObject;
import com.github.cwilper.fcrepo.dto.core.io.DateUtil;
import com.github.cwilper.fcrepo.dto.foxml.FOXMLReader;
import com.github.cwilper.fcrepo.dto.foxml.FOXMLWriter;
import com.github.cwilper.fcrepo.httpclient.FedoraHttpClient;
import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import com.github.cwilper.fcrepo.riclient.RIClient;
import com.github.cwilper.fcrepo.riclient.RIQueryResult;
import com.github.cwilper.ttff.Filter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.duraspace.fcrepo.cloudsync.api.ObjectInfo;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.service.backend.FedoraConnector;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectListHandler;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.duraspace.fcrepo.cloudsync.service.backend.PIDPatternFilter;
import org.duraspace.fcrepo.cloudsync.service.backend.StoreConnector;
import org.duraspace.fcrepo.cloudsync.service.util.JSON;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraConnector
extends StoreConnector {
    private static final Logger logger = LoggerFactory.getLogger(FedoraConnector.class);
    private final FedoraHttpClient httpClient;
    private final RIClient riClient;

    public FedoraConnector(ObjectStore store, HttpClientConfig httpClientConfig) {
        Map map = JSON.getMap((JsonNode)JSON.parse((String)store.getData()));
        String url = StringUtil.validate((String)"url", (String)((String)map.get("url")));
        String username = StringUtil.validate((String)"username", (String)((String)map.get("username")));
        String password = StringUtil.validate((String)"password", (String)((String)map.get("password")));
        this.httpClient = new FedoraHttpClient(httpClientConfig, URI.create(url), username, password);
        this.setPreemptiveAuth(this.httpClient);
        this.riClient = new RIClient(this.httpClient);
    }

    public void listObjects(ObjectQuery query, ObjectListHandler handler) {
        String type = query.getType();
        if (type.equals("pidPattern")) {
            RIQueryResult result = this.riClient.itql("select $o from <#ri> where $o <fedora-model:hasModel> <info:fedora/fedora-system:FedoraObject-3.0>", false);
            this.listObjects(result, (Filter)new PIDPatternFilter(query.getPidPattern()), handler);
        } else if (type.equals("pidList")) {
            this.listObjects(query.getPidList().iterator(), handler);
        } else if (type.equals("query")) {
            RIQueryResult result;
            if (query.getQueryType().equals("iTQL")) {
                result = this.riClient.itql(query.getQueryText(), false);
            } else if (query.getQueryType().equals("SPARQL")) {
                result = this.riClient.sparql(query.getQueryText(), false);
            } else {
                throw new IllegalArgumentException("Query type '" + query.getQueryType() + "' unrecognized.");
            }
            this.listObjects(result, null, handler);
        }
    }

    protected boolean hasObject(String pid) {
        return this.headCheck((HttpClient)this.httpClient, this.getObjectURI(pid));
    }

    public FedoraObject getObject(String pid) {
        InputStream in = this.getStream((HttpClient)this.httpClient, this.getObjectURI(pid) + "/export?context=migrate");
        if (in == null) {
            return null;
        }
        try {
            return new FOXMLReader().readObject(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean putObject(FedoraObject o, StoreConnector source, boolean overwrite, boolean copyExternal, boolean copyRedirect) {
        boolean bl;
        boolean existed = this.hasObject(o.pid());
        if (existed) {
            if (overwrite) {
                this.delete((HttpClient)this.httpClient, this.getObjectURI(o.pid()));
            } else {
                return existed;
            }
        }
        FOXMLWriter writer = new FOXMLWriter();
        File tempFile = null;
        FileOutputStream out = null;
        try {
            this.stageManagedContent(o, source);
            this.stageAndConvertERDatastreams(o, source, copyExternal, copyRedirect);
            tempFile = File.createTempFile("cloudsync", null);
            out = new FileOutputStream(tempFile);
            writer.writeObject(o, (OutputStream)out);
            ((OutputStream)out).close();
            this.post((HttpClient)this.httpClient, this.getObjectURI(o.pid()), tempFile, "text/xml");
            bl = existed;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                if (tempFile != null) {
                    tempFile.delete();
                }
                writer.close();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        if (tempFile != null) {
            tempFile.delete();
        }
        writer.close();
        return bl;
    }

    private void stageAndConvertERDatastreams(FedoraObject o, StoreConnector source, boolean copyExternal, boolean copyRedirect) throws IOException {
        for (Datastream ds : o.datastreams().values()) {
            ControlGroup g = ds.controlGroup();
            if ((!g.equals((Object)ControlGroup.EXTERNAL) || !copyExternal) && (!g.equals((Object)ControlGroup.REDIRECT) || !copyRedirect)) continue;
            this.stageVersions(o, ds, source);
            ds.controlGroup(ControlGroup.MANAGED);
        }
    }

    private void stageManagedContent(FedoraObject o, StoreConnector source) throws IOException {
        for (Datastream ds : o.datastreams().values()) {
            if (!ds.controlGroup().equals((Object)ControlGroup.MANAGED)) continue;
            this.stageVersions(o, ds, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stageVersions(FedoraObject o, Datastream ds, StoreConnector source) throws IOException {
        for (DatastreamVersion dsv : ds.versions()) {
            InputStream in = source.getContent(o, ds, dsv);
            File tempFile = File.createTempFile("cloudsync", null);
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                dsv.contentLocation(this.upload(tempFile));
            }
            finally {
                if (tempFile.delete()) continue;
                logger.warn("Failed to delete temporary file {}", (Object)tempFile);
            }
        }
    }

    private URI upload(File file) throws IOException {
        String url = this.httpClient.getBaseURI() + "/upload";
        logger.debug("Doing Multipart POST on " + url);
        HttpPost post = new HttpPost(url);
        String body = null;
        try {
            FileBody fileBody = new FileBody(file);
            MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.STRICT);
            reqEntity.addPart("file", (ContentBody)fileBody);
            post.setEntity((HttpEntity)reqEntity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            HttpEntity resEntity = response.getEntity();
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 202) {
                throw new RuntimeException("Unexpected response code (" + responseCode + ") posting " + url);
            }
            body = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            return new URI(body);
        }
        catch (URISyntaxException e) {
            throw new IOException("Error staging datastream content; response to /upload request was not a URI: " + body);
        }
    }

    private String getObjectURI(String pid) {
        return this.httpClient.getBaseURI() + "/objects/" + pid;
    }

    public InputStream getContent(FedoraObject o, Datastream ds, DatastreamVersion dsv) {
        String url = this.getObjectURI(o.pid()) + "/datastreams/" + ds.id() + "/content?asOfDateTime=" + DateUtil.toString((Date)dsv.createdDate());
        return this.getStream((HttpClient)this.httpClient, url);
    }

    public void close() {
        this.httpClient.close();
    }

    private void listObjects(RIQueryResult result, Filter<String> filter, ObjectListHandler handler) {
        try {
            boolean keepGoing = true;
            while (result.hasNext() && keepGoing) {
                List row = (List)result.next();
                String pid = ((Value)row.get(0)).toString().substring(12);
                if (filter != null && filter.accept((Object)pid) == null) continue;
                ObjectInfo o = new ObjectInfo();
                o.setPid(pid);
                keepGoing = handler.handleObject(o);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error iterating query results", e);
        }
        finally {
            result.close();
        }
    }

    private void setPreemptiveAuth(FedoraHttpClient httpClient) {
        this.localContext = new BasicHttpContext();
        BasicScheme basicAuth = new BasicScheme();
        this.localContext.setAttribute("preemptive-auth", (Object)basicAuth);
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
    }
}

