/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.ControlGroup;
import com.github.cwilper.fcrepo.dto.core.Datastream;
import com.github.cwilper.fcrepo.dto.core.DatastreamVersion;
import com.github.cwilper.fcrepo.dto.core.FedoraObject;
import com.github.cwilper.fcrepo.dto.foxml.FOXMLReader;
import com.github.cwilper.fcrepo.dto.foxml.FOXMLWriter;
import com.github.cwilper.ttff.Filter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.duraspace.fcrepo.cloudsync.api.ObjectInfo;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectListHandler;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.duraspace.fcrepo.cloudsync.service.backend.PIDPatternFilter;
import org.duraspace.fcrepo.cloudsync.service.backend.StoreConnector;
import org.duraspace.fcrepo.cloudsync.service.util.JSON;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilesystemConnector
extends StoreConnector {
    private static final Logger logger = LoggerFactory.getLogger(FilesystemConnector.class);
    private final File baseDir;

    public FilesystemConnector(ObjectStore store) {
        Map map = JSON.getMap((JsonNode)JSON.parse((String)store.getData()));
        String path = StringUtil.validate((String)"path", (String)((String)map.get("path")));
        this.baseDir = new File(path);
        if (!this.baseDir.isDirectory() && !this.baseDir.mkdir()) {
            throw new IllegalArgumentException("Cannot create base directory: " + this.baseDir);
        }
    }

    public void listObjects(ObjectQuery query, ObjectListHandler handler) {
        String type = query.getType();
        if (type.equals("pidPattern")) {
            this.listObjects(this.baseDir, (Filter)new PIDPatternFilter(query.getPidPattern()), handler);
        } else if (type.equals("pidList")) {
            this.listObjects(query.getPidList().iterator(), handler);
        } else {
            throw new UnsupportedOperationException("Filesystem store does not support " + query.getQueryType() + " queries.");
        }
    }

    private void listObjects(File dir, Filter<String> filter, ObjectListHandler handler) {
        for (File child : dir.listFiles()) {
            if (child.isDirectory()) {
                this.listObjects(child, filter, handler);
                continue;
            }
            String[] parts = FilesystemConnector.decode((String)child.getName());
            String pid = parts[0];
            try {
                if (parts[1] != null || filter.accept((Object)pid) == null) continue;
                ObjectInfo info = new ObjectInfo();
                info.setPid(pid);
                handler.handleObject(info);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean hasObject(String pid) {
        return this.getFile(pid, null, null).exists();
    }

    public FedoraObject getObject(String pid) {
        InputStream foxml = this.getStream(pid, null, null);
        if (foxml == null) {
            return null;
        }
        FOXMLReader reader = new FOXMLReader();
        try {
            FedoraObject fedoraObject = reader.readObject(foxml);
            return fedoraObject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            reader.close();
        }
    }

    public boolean putObject(FedoraObject o, StoreConnector source, boolean overwrite, boolean copyExternal, boolean copyRedirect) {
        boolean existed = this.hasObject(o.pid());
        if (existed && !overwrite) {
            return existed;
        }
        FOXMLWriter writer = new FOXMLWriter();
        File foxmlFile = null;
        FileOutputStream out = null;
        try {
            for (Datastream ds : o.datastreams().values()) {
                ControlGroup c = ds.controlGroup();
                if ((!c.equals((Object)ControlGroup.EXTERNAL) || !copyExternal) && (!c.equals((Object)ControlGroup.REDIRECT) || !copyRedirect)) continue;
                ds.controlGroup(ControlGroup.MANAGED);
            }
            foxmlFile = this.getFile(o.pid(), null, null);
            foxmlFile.getParentFile().mkdirs();
            out = new FileOutputStream(foxmlFile);
            writer.writeObject(o, (OutputStream)out);
            ((OutputStream)out).close();
            writer.close();
            this.putDatastreams(o, source);
            return existed;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(out);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putDatastreams(FedoraObject o, StoreConnector source) throws IOException {
        boolean success = false;
        HashSet files = new HashSet();
        try {
            for (Datastream ds : o.datastreams().values()) {
                if (!ds.controlGroup().equals((Object)ControlGroup.MANAGED)) continue;
                this.putVersions(o, ds, source, files);
            }
            success = true;
        }
        finally {
            if (!success) {
                logger.info("Cleaning up after failure to put datastream(s) for {}", (Object)o.pid());
                for (File file : files) {
                    if (file.delete()) continue;
                    logger.warn("Unable to delete {} after failed put", (Object)file.getPath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putVersions(FedoraObject o, Datastream ds, StoreConnector source, Set<File> files) throws IOException {
        for (DatastreamVersion dsv : ds.versions()) {
            InputStream in = source.getContent(o, ds, dsv);
            File file = this.getFile(o.pid(), ds.id(), dsv.id());
            FileOutputStream out = new FileOutputStream(file);
            try {
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
            files.add(file);
        }
    }

    public InputStream getContent(FedoraObject o, Datastream ds, DatastreamVersion dsv) {
        return this.getStream(o.pid(), ds.id(), dsv.id());
    }

    public void close() {
    }

    private InputStream getStream(String pid, String dsId, String dsVersionId) {
        File file = this.getFile(pid, dsId, dsVersionId);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private File getFile(String pid, String dsId, String dsVersionId) {
        File dir = new File(this.baseDir, FilesystemConnector.getPath((String)pid));
        String filename = FilesystemConnector.encode((String)pid, (String)dsId, (String)dsVersionId);
        return new File(dir, filename);
    }

    static String getPath(String pid) {
        String hex = DigestUtils.md5Hex((String)pid);
        return "" + hex.charAt(0) + hex.charAt(1) + '/' + hex.charAt(2) + hex.charAt(3);
    }

    static String encode(String pid, String dsId, String dsVersionId) {
        if (dsId == null) {
            return FilesystemConnector.encodePart((String)pid);
        }
        return FilesystemConnector.encodePart((String)pid) + '+' + FilesystemConnector.encodePart((String)dsId) + '+' + FilesystemConnector.encodePart((String)dsVersionId);
    }

    static String[] decode(String filename) {
        int i = filename.indexOf("+");
        if (i == -1) {
            return new String[]{FilesystemConnector.decodePart((String)filename), null, null};
        }
        int j = filename.lastIndexOf("+");
        return new String[]{FilesystemConnector.decodePart((String)filename.substring(0, i)), FilesystemConnector.decodePart((String)filename.substring(i + 1, j)), FilesystemConnector.decodePart((String)filename.substring(j + 1))};
    }

    private static String encodePart(String string) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z') {
                out.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                out.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                out.append(c);
                continue;
            }
            if (c == '-' || c == '=' || c == '(' || c == ')' || c == '[' || c == ']' || c == ';') {
                out.append(c);
                continue;
            }
            if (c == ':') {
                out.append("%3A");
                continue;
            }
            if (c == ' ') {
                out.append("%20");
                continue;
            }
            if (c == '+') {
                out.append("%2B");
                continue;
            }
            if (c == '_') {
                out.append("%5F");
                continue;
            }
            if (c == '*') {
                out.append("%2A");
                continue;
            }
            if (c == '.') {
                if (i == string.length() - 1) {
                    out.append("%2E");
                    continue;
                }
                out.append(".");
                continue;
            }
            try {
                out.append(URLEncoder.encode("" + c, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException wontHappen) {
                throw new RuntimeException(wontHappen);
            }
        }
        return out.toString();
    }

    private static String decodePart(String string) {
        if (string.endsWith("%2E")) {
            string = string.substring(0, string.length() - 3) + ".";
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new RuntimeException(wontHappen);
        }
    }
}

