/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.duraspace.fcrepo.cloudsync.api.ObjectInfo;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectListHandler;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.duraspace.fcrepo.cloudsync.service.backend.StoreConnector;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCanceledException;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCompletionListener;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskRunner;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectSetDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectStoreDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskDao;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;
import org.duraspace.fcrepo.cloudsync.service.util.JSON;

public class ListTaskRunner
extends TaskRunner
implements ObjectListHandler {
    private final String setId;
    private final String storeId;
    private final Set<String> relatedSetIds = new HashSet();
    private final Set<String> relatedStoreIds = new HashSet();
    private final HttpClientConfig httpClientConfig;
    private TaskCanceledException canceledException;

    public ListTaskRunner(Task task, TaskDao taskDao, ObjectSetDao objectSetDao, ObjectStoreDao objectStoreDao, PrintWriter logWriter, TaskCompletionListener completionListener, HttpClientConfig httpClientConfig) {
        super(task, taskDao, objectSetDao, objectStoreDao, logWriter, completionListener);
        Map map = JSON.getMap((JsonNode)JSON.parse((String)task.getData()));
        this.setId = URIMapper.getId((URI)URI.create((String)map.get("setUri")));
        this.storeId = URIMapper.getId((URI)URI.create((String)map.get("storeUri")));
        this.relatedSetIds.add(this.setId);
        this.relatedStoreIds.add(this.storeId);
        this.httpClientConfig = httpClientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() throws Exception {
        StoreConnector connector = StoreConnector.getInstance((ObjectStore)this.objectStoreDao.getObjectStore(this.storeId), (HttpClientConfig)this.httpClientConfig);
        try {
            ObjectQuery query = new ObjectQuery(this.objectSetDao.getObjectSet(this.setId));
            connector.listObjects(query, (ObjectListHandler)this);
            if (this.canceledException != null) {
                throw this.canceledException;
            }
        }
        finally {
            connector.close();
        }
    }

    public Set<String> getRelatedSetIds() {
        return this.relatedSetIds;
    }

    public Set<String> getRelatedStoreIds() {
        return this.relatedStoreIds;
    }

    public boolean handleObject(ObjectInfo info) {
        this.logWriter.println(info.getPid());
        try {
            this.pauseOrCancelIfRequested();
            return true;
        }
        catch (TaskCanceledException e) {
            this.canceledException = e;
            return false;
        }
    }
}

