/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.duraspace.fcrepo.cloudsync.api.ObjectSet;
import org.duraspace.fcrepo.cloudsync.service.util.JSON;

public class ObjectQuery {
    private final String type;
    private final String pidPattern;
    private final List<String> pidList;
    private final String queryType;
    private final String queryText;

    public ObjectQuery(ObjectSet set) {
        this.type = set.getType();
        if (this.type == null || this.type.trim().length() == 0) {
            throw new IllegalArgumentException("ObjectSet type not specified");
        }
        if (this.type.equals("pidPattern")) {
            this.pidPattern = set.getData();
            this.pidList = null;
            this.queryType = null;
            this.queryText = null;
        } else if (this.type.equals("pidList")) {
            this.pidPattern = null;
            this.pidList = new ArrayList();
            String[] pids = set.getData().split("\\s+");
            this.pidList.addAll(Arrays.asList(pids));
            this.queryType = null;
            this.queryText = null;
        } else if (this.type.equals("query")) {
            this.pidPattern = null;
            this.pidList = null;
            Map map = JSON.getMap((JsonNode)JSON.parse((String)set.getData()));
            this.queryType = (String)map.get("queryType");
            this.queryText = (String)map.get("queryText");
        } else {
            throw new IllegalArgumentException("Unrecognized ObjectSet type: " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getPidPattern() {
        return this.pidPattern;
    }

    public List<String> getPidList() {
        return this.pidList;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getQueryText() {
        return this.queryText;
    }
}

