/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.Datastream;
import com.github.cwilper.fcrepo.dto.core.DatastreamVersion;
import com.github.cwilper.fcrepo.dto.core.FedoraObject;
import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.duraspace.fcrepo.cloudsync.api.ObjectInfo;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.service.backend.DuraCloudConnector;
import org.duraspace.fcrepo.cloudsync.service.backend.FedoraConnector;
import org.duraspace.fcrepo.cloudsync.service.backend.FilesystemConnector;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectListHandler;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreConnector {
    private static final Logger logger = LoggerFactory.getLogger(StoreConnector.class);
    protected BasicHttpContext localContext = null;

    public static StoreConnector getInstance(ObjectStore store, HttpClientConfig httpClientConfig) {
        if (store.getType().equals("fedora")) {
            return new FedoraConnector(store, httpClientConfig);
        }
        if (store.getType().equals("duracloud")) {
            return new DuraCloudConnector(store, httpClientConfig);
        }
        if (store.getType().equals("filesystem")) {
            return new FilesystemConnector(store);
        }
        throw new IllegalArgumentException("Unrecognized ObjectStore type: " + store.getType());
    }

    protected void listObjects(Iterator<String> pidIterator, ObjectListHandler handler) {
        boolean keepGoing = true;
        while (pidIterator.hasNext() && keepGoing) {
            String pid = pidIterator.next();
            if (!this.hasObject(pid)) continue;
            ObjectInfo o = new ObjectInfo();
            o.setPid(pid);
            keepGoing = handler.handleObject(o);
        }
    }

    protected boolean headCheck(HttpClient httpClient, String url) {
        logger.debug("Doing HEAD request on " + url);
        HttpHead head = new HttpHead(url);
        try {
            HttpResponse response = this.execute(httpClient, (HttpUriRequest)head);
            int responseCode = response.getStatusLine().getStatusCode();
            logger.debug("responseCode: " + responseCode);
            return responseCode == 200;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getString(HttpClient httpClient, String url) {
        try {
            HttpEntity entity = this.get(httpClient, url);
            if (entity == null) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected InputStream getStream(HttpClient httpClient, String url) {
        try {
            HttpEntity entity = this.get(httpClient, url);
            if (entity == null) {
                return null;
            }
            return entity.getContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpEntity get(HttpClient httpClient, String url) throws IOException {
        logger.debug("Doing GET request on " + url);
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = this.execute(httpClient, (HttpUriRequest)get);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 404) {
                return null;
            }
            if (responseCode != 200) {
                throw new RuntimeException("Unexpected response code (" + responseCode + ") getting " + url);
            }
            return response.getEntity();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void delete(HttpClient httpClient, String url) {
        logger.debug("Doing DELETE request on " + url);
        HttpDelete delete = new HttpDelete(url);
        HttpEntity entity = null;
        try {
            HttpResponse response = this.execute(httpClient, (HttpUriRequest)delete);
            entity = response.getEntity();
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200 && responseCode != 204) {
                throw new RuntimeException("Unexpected response code (" + responseCode + ") deleting " + url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (Exception e) {}
            }
        }
    }

    protected void post(HttpClient httpClient, String url, File file, String mimeType) {
        logger.debug("Doing POST request on " + url);
        HttpPost post = new HttpPost(url);
        HttpEntity entity = null;
        try {
            post.setHeader("Content-type", mimeType);
            post.setEntity((HttpEntity)new FileEntity(file, mimeType));
            HttpResponse response = this.execute(httpClient, (HttpUriRequest)post);
            entity = response.getEntity();
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode < 200 || responseCode > 204) {
                throw new RuntimeException("Unexpected response code (" + responseCode + ") posting " + url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (Exception e) {}
            }
        }
    }

    protected void put(HttpClient httpClient, String url, File file, String mimeType) {
        logger.debug("Doing PUT request on " + url);
        HttpPut put = new HttpPut(url);
        HttpEntity entity = null;
        try {
            if (mimeType == null || mimeType.trim().length() == 0) {
                mimeType = "application/octet-stream";
            }
            put.setEntity((HttpEntity)new FileEntity(file, mimeType));
            HttpResponse response = this.execute(httpClient, (HttpUriRequest)put);
            entity = response.getEntity();
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200 && responseCode != 201 && responseCode != 204) {
                throw new RuntimeException("Unexpected response code (" + responseCode + ") putting " + url);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (Exception e) {}
            }
        }
    }

    private HttpResponse execute(HttpClient client, HttpUriRequest request) throws IOException {
        if (this.localContext != null) {
            return client.execute(request, (HttpContext)this.localContext);
        }
        return client.execute(request);
    }

    public abstract void listObjects(ObjectQuery var1, ObjectListHandler var2);

    protected abstract boolean hasObject(String var1);

    public abstract FedoraObject getObject(String var1);

    public abstract boolean putObject(FedoraObject var1, StoreConnector var2, boolean var3, boolean var4, boolean var5);

    public abstract InputStream getContent(FedoraObject var1, Datastream var2, DatastreamVersion var3);

    public abstract void close();
}

