/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.io.DateUtil;
import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCompletionListener;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskRunner;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectSetDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectStoreDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskLogDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskManager
extends Thread
implements TaskCompletionListener {
    private static final Logger logger = LoggerFactory.getLogger(TaskManager.class);
    private static final int POLL_SECONDS = 5;
    private final TaskDao taskDao;
    private final TaskLogDao taskLogDao;
    private final ObjectSetDao objectSetDao;
    private final ObjectStoreDao objectStoreDao;
    private final HttpClientConfig httpClientConfig;
    private final Map<String, TaskRunner> runners;
    private boolean shutdownRequested;

    public TaskManager(TaskDao taskDao, TaskLogDao taskLogDao, ObjectSetDao objectSetDao, ObjectStoreDao objectStoreDao, HttpClientConfig httpClientConfig) {
        this.taskDao = taskDao;
        this.taskLogDao = taskLogDao;
        this.objectSetDao = objectSetDao;
        this.objectStoreDao = objectStoreDao;
        this.httpClientConfig = httpClientConfig;
        this.runners = new HashMap();
    }

    private synchronized void mainLoop() {
        for (Task task : this.taskDao.listTasks()) {
            if (task.getState().equals("Starting")) {
                this.startTask(task);
                continue;
            }
            if (task.getState().equals("Pausing")) {
                this.pauseTask(task);
                continue;
            }
            if (task.getState().equals("Resuming")) {
                this.resumeTask(task);
                continue;
            }
            if (!task.getState().equals("Canceling")) continue;
            this.cancelTask(task);
        }
        try {
            this.wait(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.cleanup(true);
        while (!this.shutdownRequested) {
            this.mainLoop();
        }
        this.cleanup(false);
    }

    private void cleanup(boolean atStartup) {
        boolean allTasksIdle = false;
        while (!allTasksIdle) {
            int activeCount = 0;
            for (Task task : this.taskDao.listTasks()) {
                if (task.getState().equals("Idle")) continue;
                ++activeCount;
                if (!task.getState().equals("Canceling")) {
                    logger.info("Auto-canceling task " + task.getId() + " (" + task.getName() + ")");
                    this.taskDao.setTaskState(task.getId(), "Canceling");
                    task.setState("Canceling");
                }
                if (atStartup) {
                    this.taskCanceled(task);
                    continue;
                }
                this.cancelTask(task);
            }
            if (activeCount == 0 || atStartup) {
                allTasksIdle = true;
                continue;
            }
            logger.info("Waiting for " + activeCount + " task(s) to go idle.");
            TaskManager.sleepSeconds((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask(Task task) {
        String taskLogId = this.taskLogDao.start(task.getId());
        PrintWriter logWriter = this.taskLogDao.getContentWriter(taskLogId);
        Date startDate = this.taskLogDao.getTaskLog(taskLogId).getStartDate();
        logWriter.println("# Started at " + DateUtil.toString((Date)startDate));
        TaskRunner runner = TaskRunner.getInstance((Task)task, (TaskDao)this.taskDao, (ObjectSetDao)this.objectSetDao, (ObjectStoreDao)this.objectStoreDao, (PrintWriter)logWriter, (TaskCompletionListener)this, (HttpClientConfig)this.httpClientConfig);
        Map map = this.runners;
        synchronized (map) {
            this.runners.put(task.getId(), runner);
        }
        runner.start();
        task.setActiveLogId(taskLogId);
        this.taskDao.setActiveLogId(task.getId(), task.getActiveLogId());
        this.taskDao.setTaskState(task.getId(), "Running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseTask(Task task) {
        Map map = this.runners;
        synchronized (map) {
            TaskRunner runner = (TaskRunner)this.runners.get(task.getId());
            if (runner != null) {
                runner.requestPause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeTask(Task task) {
        Map map = this.runners;
        synchronized (map) {
            TaskRunner runner = (TaskRunner)this.runners.get(task.getId());
            if (runner != null) {
                runner.requestResume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTask(Task task) {
        Map map = this.runners;
        synchronized (map) {
            TaskRunner runner = (TaskRunner)this.runners.get(task.getId());
            if (runner != null) {
                runner.requestCancel();
                this.runners.remove(task.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested = true;
        logger.info("Shutdown requested.");
        TaskManager taskManager = this;
        synchronized (taskManager) {
            this.notifyAll();
        }
        while (this.isAlive()) {
            TaskManager.sleepSeconds((int)1);
        }
        logger.info("All tasks idle.");
    }

    private static void sleepSeconds(int seconds) {
        try {
            Thread.sleep(1000 * seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Date taskSucceeded(Task task) {
        this.taskDao.goIdle(task.getId());
        return this.taskLogDao.finish(task.getActiveLogId(), "Succeeded");
    }

    public Date taskFailed(Task task, Throwable cause) {
        this.taskDao.goIdle(task.getId());
        return this.taskLogDao.finish(task.getActiveLogId(), "Failed");
    }

    public Date taskCanceled(Task task) {
        this.taskDao.goIdle(task.getId());
        return this.taskLogDao.finish(task.getActiveLogId(), "Canceled");
    }
}

