/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.backend;

import com.github.cwilper.fcrepo.dto.core.io.DateUtil;
import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Set;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.service.backend.CopyTaskRunner;
import org.duraspace.fcrepo.cloudsync.service.backend.ListTaskRunner;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCanceledException;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskCompletionListener;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectSetDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectStoreDao;
import org.duraspace.fcrepo.cloudsync.service.dao.TaskDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TaskRunner
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(TaskRunner.class);
    protected final Task task;
    protected final TaskDao taskDao;
    protected final ObjectSetDao objectSetDao;
    protected final ObjectStoreDao objectStoreDao;
    protected final PrintWriter logWriter;
    protected final TaskCompletionListener completionListener;
    protected boolean pauseRequested;
    protected boolean resumeRequested;
    protected boolean cancelRequested;

    protected TaskRunner(Task task, TaskDao taskDao, ObjectSetDao objectSetDao, ObjectStoreDao objectStoreDao, PrintWriter logWriter, TaskCompletionListener completionListener) {
        this.task = task;
        this.taskDao = taskDao;
        this.objectSetDao = objectSetDao;
        this.objectStoreDao = objectStoreDao;
        this.logWriter = logWriter;
        this.completionListener = completionListener;
    }

    public static final TaskRunner getInstance(Task task, TaskDao taskDao, ObjectSetDao objectSetDao, ObjectStoreDao objectStoreDao, PrintWriter logWriter, TaskCompletionListener completionListener, HttpClientConfig httpClientConfig) {
        if (task.getType() != null && task.getType().length() > 0) {
            if (task.getType().equals("list")) {
                return new ListTaskRunner(task, taskDao, objectSetDao, objectStoreDao, logWriter, completionListener, httpClientConfig);
            }
            if (task.getType().equals("copy")) {
                return new CopyTaskRunner(task, taskDao, objectSetDao, objectStoreDao, logWriter, completionListener, httpClientConfig);
            }
            throw new IllegalArgumentException("Unrecognized Task type: " + task.getType());
        }
        throw new IllegalArgumentException("Task type not specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void run() {
        Date completionDate = null;
        String resultType = null;
        try {
            this.logger.info("Task " + this.task.getId() + " started (" + this.task.getName() + ")");
            this.pauseOrCancelIfRequested();
            this.runTask();
            this.pauseOrCancelIfRequested();
            this.logger.info("Task " + this.task.getId() + " succeeded (" + this.task.getName() + ")");
            completionDate = this.completionListener.taskSucceeded(this.task);
            resultType = "succeeded";
            this.logWriter.println("# Finished (" + resultType + ") at " + DateUtil.toString((Date)completionDate));
            this.logWriter.close();
        }
        catch (TaskCanceledException e) {
            this.logger.info("Task " + this.task.getId() + " canceled (" + this.task.getName() + ")");
            completionDate = this.completionListener.taskCanceled(this.task);
            resultType = "canceled";
            this.logWriter.println("# Finished (" + resultType + ") at " + DateUtil.toString((Date)completionDate));
            this.logWriter.close();
        }
        catch (Throwable th) {
            this.logger.info("Task " + this.task.getId() + " failed (" + this.task.getName() + ")");
            completionDate = this.completionListener.taskFailed(this.task, th);
            resultType = "failed";
            this.logWriter.print("ERROR: ");
            th.printStackTrace(this.logWriter);
            this.logWriter.println("# Finished (" + resultType + ") at " + DateUtil.toString((Date)completionDate));
            this.logWriter.close();
            {
                catch (Throwable throwable) {
                    this.logWriter.println("# Finished (" + resultType + ") at " + DateUtil.toString(completionDate));
                    this.logWriter.close();
                    throw throwable;
                }
            }
        }
    }

    protected abstract void runTask() throws Exception;

    protected void pauseOrCancelIfRequested() throws TaskCanceledException {
        if (this.cancelRequested) {
            throw new TaskCanceledException();
        }
        if (this.pauseRequested) {
            this.taskDao.setTaskState(this.task.getId(), "Paused");
            this.logger.info("Task " + this.task.getId() + " paused (" + this.task.getName() + ")");
            this.logWriter.println("# Paused at " + DateUtil.toString((Date)new Date()));
            while (!this.resumeRequested) {
                if (this.cancelRequested) {
                    throw new TaskCanceledException();
                }
                try {
                    TaskRunner.sleep((long)5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.taskDao.setTaskState(this.task.getId(), "Running");
            this.logger.info("Task " + this.task.getId() + " resumed (" + this.task.getName() + ")");
            this.logWriter.println("# Resumed at " + DateUtil.toString((Date)new Date()));
            this.pauseRequested = false;
            this.resumeRequested = false;
        }
    }

    public Task getTask() {
        return this.task;
    }

    public void requestPause() {
        this.pauseRequested = true;
        this.resumeRequested = false;
        this.cancelRequested = false;
    }

    public void requestResume() {
        this.pauseRequested = false;
        this.resumeRequested = true;
        this.cancelRequested = false;
    }

    public void requestCancel() {
        this.pauseRequested = false;
        this.resumeRequested = false;
        this.cancelRequested = true;
    }

    public abstract Set<String> getRelatedSetIds();

    public abstract Set<String> getRelatedStoreIds();
}

