/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.duraspace.fcrepo.cloudsync.api.ObjectSet;
import org.duraspace.fcrepo.cloudsync.service.backend.ObjectQuery;
import org.duraspace.fcrepo.cloudsync.service.dao.AbstractDao;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectSetDao
extends AbstractDao {
    private static final String CREATE_DDL = "CREATE TABLE ObjectSets (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  name VARCHAR(256) NOT NULL,\n  type VARCHAR(32) NOT NULL,\n  data VARCHAR(32672) NOT NULL,\n  CONSTRAINT ObjectSetUniqueName unique (name))";
    private static final String UPDATE_SQL = "UPDATE ObjectSets\nSET name = ?, type= ?, data = ?\nWHERE id = ?";

    public ObjectSetDao(JdbcTemplate db) {
        super(db);
    }

    public void initDb() {
        this.db.execute("CREATE TABLE ObjectSets (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  name VARCHAR(256) NOT NULL,\n  type VARCHAR(32) NOT NULL,\n  data VARCHAR(32672) NOT NULL,\n  CONSTRAINT ObjectSetUniqueName unique (name))");
        ObjectSet o = new ObjectSet();
        o.setName("All Objects");
        o.setType("pidPattern");
        o.setData("*");
        this.createObjectSet(o);
    }

    public ObjectSet createObjectSet(ObjectSet objectSet) throws DuplicateKeyException {
        if (StringUtil.normalize((String)objectSet.getId()) != null) {
            throw new IllegalArgumentException("Specifying the Object Set id during creation is not permitted");
        }
        objectSet.setName(StringUtil.validate((String)"name", (String)objectSet.getName(), (int)256));
        objectSet.setType(StringUtil.validate((String)"type", (String)objectSet.getType(), (int)32));
        objectSet.setData(StringUtil.validate((String)"data", (String)objectSet.getData(), (int)32672));
        new ObjectQuery(objectSet);
        String id = this.insert("INSERT INTO ObjectSets (name, type, data) VALUES (?, ?, ?)", new Object[]{objectSet.getName(), objectSet.getType(), objectSet.getData()});
        return this.getObjectSet(id);
    }

    public List<ObjectSet> listObjectSets() {
        return this.db.query("SELECT * FROM ObjectSets", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ObjectSet getObjectSet(String id) {
        return (ObjectSet)this.db.query("SELECT * FROM ObjectSets WHERE id = ?", (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */, new Object[]{Integer.parseInt(id)});
    }

    private static ObjectSet getObjectSet(ResultSet rs) throws SQLException {
        ObjectSet o = new ObjectSet();
        o.setId("" + rs.getInt("id"));
        o.setName(rs.getString("name"));
        o.setType(rs.getString("type"));
        o.setData(rs.getString("data"));
        return o;
    }

    public ObjectSet updateObjectSet(String id, ObjectSet set) throws DuplicateKeyException {
        ObjectSet orig = this.getObjectSet(id);
        String newId = StringUtil.normalize((String)set.getId());
        if (newId != null && !newId.equals(id)) {
            throw new UnsupportedOperationException("Changing the ObjectSet id is not permitted");
        }
        this.updateObjectSet(orig, set);
        return this.getObjectSet(orig.getId());
    }

    private void updateObjectSet(ObjectSet orig, ObjectSet mods) {
        if (StringUtil.normalize((String)mods.getName()) != null) {
            orig.setName(StringUtil.validate((String)"name", (String)mods.getName(), (int)256));
        }
        if (StringUtil.normalize((String)mods.getType()) != null) {
            orig.setType(StringUtil.validate((String)"type", (String)mods.getType(), (int)32));
        }
        if (StringUtil.normalize((String)mods.getData()) != null) {
            orig.setData(StringUtil.validate((String)"data", (String)mods.getData(), (int)32672));
        }
        int objectSetId = Integer.parseInt(orig.getId());
        new ObjectQuery(orig);
        this.db.update("UPDATE ObjectSets\nSET name = ?, type= ?, data = ?\nWHERE id = ?", new Object[]{orig.getName(), orig.getType(), orig.getData(), objectSetId});
    }

    public void deleteObjectSet(String id) {
        this.db.update("DELETE FROM ObjectSets WHERE id = ?", new Object[]{Integer.parseInt(id)});
    }

    static /* synthetic */ ObjectSet access$000(ResultSet x0) throws SQLException {
        return ObjectSetDao.getObjectSet((ResultSet)x0);
    }
}

