/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.dao;

import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.service.backend.StoreConnector;
import org.duraspace.fcrepo.cloudsync.service.dao.AbstractDao;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectStoreDao
extends AbstractDao {
    private static final String CREATE_DDL = "CREATE TABLE ObjectStores (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  name VARCHAR(256) NOT NULL,\n  type VARCHAR(32) NOT NULL,\n  data VARCHAR(1024) NOT NULL,\n  CONSTRAINT ObjectStoreUniqueName unique (name))";

    public ObjectStoreDao(JdbcTemplate db) {
        super(db);
    }

    public void initDb() {
        this.db.execute("CREATE TABLE ObjectStores (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  name VARCHAR(256) NOT NULL,\n  type VARCHAR(32) NOT NULL,\n  data VARCHAR(1024) NOT NULL,\n  CONSTRAINT ObjectStoreUniqueName unique (name))");
    }

    public ObjectStore createObjectStore(ObjectStore objectStore) throws DuplicateKeyException {
        if (StringUtil.normalize((String)objectStore.getId()) != null) {
            throw new IllegalArgumentException("Specifying the Object Store id during creation is not permitted");
        }
        objectStore.setName(StringUtil.validate((String)"name", (String)objectStore.getName(), (int)256));
        objectStore.setType(StringUtil.validate((String)"type", (String)objectStore.getType(), (int)32));
        objectStore.setData(StringUtil.validate((String)"data", (String)objectStore.getData(), (int)1024));
        StoreConnector.getInstance((ObjectStore)objectStore, (HttpClientConfig)new HttpClientConfig());
        String id = this.insert("INSERT INTO ObjectStores (name, type, data) VALUES (?, ?, ?)", new Object[]{objectStore.getName(), objectStore.getType(), objectStore.getData()});
        return this.getObjectStore(id);
    }

    public List<ObjectStore> listObjectStores() {
        return this.db.query("SELECT * FROM ObjectStores", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ObjectStore getObjectStore(String id) {
        return (ObjectStore)this.db.query("SELECT * FROM ObjectStores WHERE id = ?", (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */, new Object[]{Integer.parseInt(id)});
    }

    private static ObjectStore getObjectStore(ResultSet rs) throws SQLException {
        ObjectStore o = new ObjectStore();
        o.setId("" + rs.getInt("id"));
        o.setName(rs.getString("name"));
        o.setType(rs.getString("type"));
        o.setData(rs.getString("data"));
        return o;
    }

    public void deleteObjectStore(String id) {
        this.db.update("DELETE FROM ObjectStores WHERE id = ?", new Object[]{Integer.parseInt(id)});
    }

    static /* synthetic */ ObjectStore access$000(ResultSet x0) throws SQLException {
        return ObjectStoreDao.getObjectStore((ResultSet)x0);
    }
}

