/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.dao;

import com.github.cwilper.fcrepo.httpclient.HttpClientConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.service.backend.TaskRunner;
import org.duraspace.fcrepo.cloudsync.service.dao.AbstractDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectSetDao;
import org.duraspace.fcrepo.cloudsync.service.dao.ObjectStoreDao;
import org.duraspace.fcrepo.cloudsync.service.util.StringUtil;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskDao
extends AbstractDao {
    private static final String CREATE_DDL = "CREATE TABLE Tasks (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  name VARCHAR(256) NOT NULL,\n  type VARCHAR(32) NOT NULL,\n  state VARCHAR(16) NOT NULL,\n  activeLogId INTEGER,\n  schedule VARCHAR(1024),\n  data VARCHAR(32672) NOT NULL,\n  CONSTRAINT TaskUniqueName UNIQUE (name))";
    private static final String CREATE_DDL2 = "CREATE TABLE TaskSetDeps (\n  taskId INTEGER NOT NULL,\n  setId INTEGER NOT NULL,\n  CONSTRAINT TaskSetDep_Task_FK FOREIGN KEY (taskId) REFERENCES Tasks (id),\n  CONSTRAINT TaskSetDep_Set_FK FOREIGN KEY (setId) REFERENCES ObjectSets (id))";
    private static final String CREATE_DDL3 = "CREATE TABLE TaskStoreDeps (\n  taskId INTEGER NOT NULL,\n  storeId INTEGER NOT NULL,\n  CONSTRAINT TaskStoreDep_Task_FK FOREIGN KEY (taskId) REFERENCES Tasks (id),\n  CONSTRAINT TaskStoreDep_Store_FK FOREIGN KEY (storeId) REFERENCES ObjectStores (id))";
    private static final String INSERT_SQL = "INSERT INTO Tasks (name, type, state, schedule, data) \nVALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_SQL2 = "INSERT INTO TaskSetDeps (taskId, setId) VALUES (?, ?)";
    private static final String INSERT_SQL3 = "INSERT INTO TaskStoreDeps (taskId, storeId) VALUES (?, ?)";
    private static final String UPDATE_SQL = "UPDATE Tasks\nSET name = ?, type = ?, state = ?, schedule = ?, data = ?\nWHERE id = ?";
    private static final String UPDATE_SQL2 = "UPDATE Tasks SET state = ? WHERE id = ?";
    private final TransactionTemplate tt;
    private final ObjectSetDao objectSetDao;
    private final ObjectStoreDao objectStoreDao;

    public TaskDao(JdbcTemplate db, TransactionTemplate tt, ObjectSetDao objectSetDao, ObjectStoreDao objectStoreDao) {
        super(db);
        this.tt = tt;
        this.objectSetDao = objectSetDao;
        this.objectStoreDao = objectStoreDao;
    }

    public void initDb() {
        this.db.execute("CREATE TABLE Tasks (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  name VARCHAR(256) NOT NULL,\n  type VARCHAR(32) NOT NULL,\n  state VARCHAR(16) NOT NULL,\n  activeLogId INTEGER,\n  schedule VARCHAR(1024),\n  data VARCHAR(32672) NOT NULL,\n  CONSTRAINT TaskUniqueName UNIQUE (name))");
        this.db.execute("CREATE TABLE TaskSetDeps (\n  taskId INTEGER NOT NULL,\n  setId INTEGER NOT NULL,\n  CONSTRAINT TaskSetDep_Task_FK FOREIGN KEY (taskId) REFERENCES Tasks (id),\n  CONSTRAINT TaskSetDep_Set_FK FOREIGN KEY (setId) REFERENCES ObjectSets (id))");
        this.db.execute("CREATE TABLE TaskStoreDeps (\n  taskId INTEGER NOT NULL,\n  storeId INTEGER NOT NULL,\n  CONSTRAINT TaskStoreDep_Task_FK FOREIGN KEY (taskId) REFERENCES Tasks (id),\n  CONSTRAINT TaskStoreDep_Store_FK FOREIGN KEY (storeId) REFERENCES ObjectStores (id))");
    }

    public Task createTask(Task task) {
        if (StringUtil.normalize((String)task.getId()) != null) {
            throw new IllegalArgumentException("Specifying the Task id during creation is not permitted");
        }
        task.setName(StringUtil.validate((String)"name", (String)task.getName(), (int)256));
        task.setType(StringUtil.validate((String)"type", (String)task.getType(), (int)32));
        task.setState(StringUtil.validate((String)"state", (String)task.getState(), (String[])new String[]{"Idle", "Starting"}));
        if (StringUtil.normalize((String)task.getActiveLogId()) != null) {
            throw new IllegalArgumentException("Specifying the Task activeLogId during creation is not permitted");
        }
        String sched = StringUtil.normalize((String)task.getSchedule());
        if (sched != null) {
            task.setSchedule(StringUtil.validate((String)"schedule", (String)sched, (int)1024));
        }
        task.setData(StringUtil.validate((String)"data", (String)task.getData(), (int)32672));
        TaskRunner runner = TaskRunner.getInstance((Task)task, (TaskDao)this, (ObjectSetDao)this.objectSetDao, (ObjectStoreDao)this.objectStoreDao, null, null, (HttpClientConfig)new HttpClientConfig());
        String id = (String)this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        return this.getTask(id);
    }

    public List<Task> listTasks() {
        return this.db.query("SELECT * FROM Tasks", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Task getTask(String id) {
        return (Task)this.db.query("SELECT * FROM Tasks WHERE id = ?", (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */, new Object[]{Integer.parseInt(id)});
    }

    private static Task getTask(ResultSet rs) throws SQLException {
        Task task = new Task();
        task.setId("" + rs.getInt("id"));
        task.setName(rs.getString("name"));
        task.setType(rs.getString("type"));
        task.setState(rs.getString("state"));
        Integer activeLogId = rs.getInt("activeLogId");
        if (activeLogId != null) {
            task.setActiveLogId(activeLogId.toString());
        }
        task.setSchedule(rs.getString("schedule"));
        task.setData(rs.getString("data"));
        return task;
    }

    public void setTaskState(String id, String newState) {
        this.db.update("UPDATE Tasks SET state = ? WHERE id = ?", new Object[]{newState, Integer.parseInt(id)});
    }

    public void goIdle(String id) {
        this.setTaskState(id, "Idle");
        this.setActiveLogId(id, null);
    }

    public void setActiveLogId(String id, String activeLogId) {
        Integer value = null;
        if (activeLogId != null) {
            value = Integer.parseInt(activeLogId);
        }
        this.db.update("UPDATE Tasks SET activeLogId = ? WHERE id = ?", new Object[]{value, Integer.parseInt(id)});
    }

    public Task updateTask(String id, Task task) throws DuplicateKeyException {
        String oldActiveLogId;
        Task orig = this.getTask(id);
        String newId = StringUtil.normalize((String)task.getId());
        if (newId != null && !newId.equals(id)) {
            throw new UnsupportedOperationException("Changing the task id is not permitted");
        }
        String newActiveLogId = StringUtil.normalize((String)task.getActiveLogId());
        if (!(newActiveLogId == null || (oldActiveLogId = orig.getActiveLogId()) != null && oldActiveLogId.equals(newActiveLogId))) {
            throw new UnsupportedOperationException("Changing the task activeLogId is not permitted");
        }
        if (orig.getState().equals("Idle")) {
            this.updateIdleTask(orig, task);
        } else {
            this.updateActiveTask(orig, task);
        }
        return this.getTask(orig.getId());
    }

    private void updateIdleTask(Task orig, Task mods) {
        String newState = StringUtil.normalize((String)mods.getState());
        if (newState != null && !newState.equals("Idle") && !newState.equals("Starting")) {
            throw new IllegalArgumentException("Illegal state transition: Idle -> " + newState);
        }
        if (newState != null) {
            orig.setState(newState);
        }
        if (StringUtil.normalize((String)mods.getName()) != null) {
            orig.setName(StringUtil.validate((String)"name", (String)mods.getName(), (int)256));
        }
        if (StringUtil.normalize((String)mods.getType()) != null) {
            orig.setType(StringUtil.validate((String)"type", (String)mods.getType(), (int)32));
        }
        if (StringUtil.normalize((String)mods.getSchedule()) != null) {
            orig.setSchedule(StringUtil.validate((String)"schedule", (String)mods.getType(), (int)1024));
        }
        if (StringUtil.normalize((String)mods.getData()) != null) {
            orig.setData(StringUtil.validate((String)"data", (String)mods.getData(), (int)32672));
        }
        TaskRunner runner = TaskRunner.getInstance((Task)orig, (TaskDao)this, (ObjectSetDao)this.objectSetDao, (ObjectStoreDao)this.objectStoreDao, null, null, (HttpClientConfig)new HttpClientConfig());
        int taskId = Integer.parseInt(orig.getId());
        this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateActiveTask(Task orig, Task mods) {
        String oldState = orig.getState();
        String newState = StringUtil.normalize((String)mods.getState());
        if (newState != null && !newState.equals(oldState)) {
            boolean illegal = false;
            if (oldState.equals("Starting") || oldState.equals("Running") || oldState.equals("Resuming")) {
                if (!newState.equals("Pausing") && !newState.equals("Canceling")) {
                    illegal = true;
                }
            } else if (oldState.equals("Pausing") || oldState.equals("Paused")) {
                if (!newState.equals("Resuming") && !newState.equals("Canceling")) {
                    illegal = true;
                }
            } else {
                illegal = true;
            }
            if (illegal) {
                throw new IllegalArgumentException("Illegal state transition: " + oldState + " -> " + newState);
            }
        }
        TaskDao.cannotChangeWhileActive((String)"name", (String)orig.getName(), (String)mods.getName());
        TaskDao.cannotChangeWhileActive((String)"type", (String)orig.getType(), (String)mods.getType());
        TaskDao.cannotChangeWhileActive((String)"schedule", (String)orig.getSchedule(), (String)mods.getSchedule());
        TaskDao.cannotChangeWhileActive((String)"data", (String)orig.getData(), (String)mods.getData());
        if (newState != null && !newState.equals(oldState)) {
            this.db.update("UPDATE Tasks SET state = ? WHERE id = ?", new Object[]{newState, Integer.parseInt(orig.getId())});
        }
    }

    private static void cannotChangeWhileActive(String name, String oldVal, String newVal) {
        if (newVal != null && !newVal.equals(oldVal)) {
            throw new IllegalArgumentException("Cannot change task " + name + " while active");
        }
    }

    public void deleteTask(String id) {
        int taskId = Integer.parseInt(id);
        this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Task access$000(ResultSet x0) throws SQLException {
        return TaskDao.getTask((ResultSet)x0);
    }
}

