/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.duraspace.fcrepo.cloudsync.api.TaskLog;
import org.duraspace.fcrepo.cloudsync.service.dao.AbstractDao;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskLogDao
extends AbstractDao {
    private static final String CREATE_DDL = "CREATE TABLE TaskLogs (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  taskId INTEGER NOT NULL,\n  resultType VARCHAR(16) NOT NULL,\n  startDate BIGINT NOT NULL,\n  finishDate BIGINT,\n  CONSTRAINT TaskLog_Task_FK FOREIGN KEY (taskId) REFERENCES Tasks (id))";

    public TaskLogDao(JdbcTemplate db) {
        super(db);
        TaskLogDao.getTaskLogDir().mkdir();
    }

    public void initDb() {
        this.db.execute("CREATE TABLE TaskLogs (\n  id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY,\n  taskId INTEGER NOT NULL,\n  resultType VARCHAR(16) NOT NULL,\n  startDate BIGINT NOT NULL,\n  finishDate BIGINT,\n  CONSTRAINT TaskLog_Task_FK FOREIGN KEY (taskId) REFERENCES Tasks (id))");
    }

    public String start(String taskId) {
        long now = System.currentTimeMillis();
        return this.insert("INSERT INTO TaskLogs (taskId, resultType, startDate) VALUES (?, ?, ?)", new Object[]{Integer.parseInt(taskId), "Incomplete", now});
    }

    public PrintWriter getContentWriter(String id) {
        try {
            FileOutputStream out = new FileOutputStream(this.getLogFile(id));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            return new PrintWriter((Writer)writer, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Date finish(String id, String resultType) {
        long now = System.currentTimeMillis();
        this.db.update("UPDATE TaskLogs SET resultType = ?, finishDate = ? WHERE id = ?", new Object[]{resultType, now, Integer.parseInt(id)});
        return new Date(now);
    }

    public List<TaskLog> listTaskLogs() {
        return this.db.query("SELECT * FROM TaskLogs ORDER BY finishDate DESC NULLS FIRST", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public TaskLog getTaskLog(String id) {
        return (TaskLog)this.db.query("SELECT * FROM TaskLogs WHERE id = ?", (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */, new Object[]{Integer.parseInt(id)});
    }

    private static TaskLog getTaskLog(ResultSet rs) throws SQLException {
        TaskLog o = new TaskLog();
        o.setId("" + rs.getInt("id"));
        o.setTaskId("" + rs.getInt("taskId"));
        o.setResultType(rs.getString("resultType"));
        o.setStartDate(TaskLogDao.getDate((ResultSet)rs, (String)"startDate"));
        o.setFinishDate(TaskLogDao.getDate((ResultSet)rs, (String)"finishDate"));
        return o;
    }

    private static Date getDate(ResultSet rs, String name) throws SQLException {
        long ms = rs.getLong(name);
        if (ms == 0L) {
            return null;
        }
        return new Date(ms);
    }

    public InputStream getTaskLogContent(String id) throws FileNotFoundException {
        return new FileInputStream(this.getLogFile(id));
    }

    public void deleteTaskLog(String id) {
        this.db.update("DELETE FROM TaskLogs WHERE id = ?", new Object[]{Integer.parseInt(id)});
        this.getLogFile(id).delete();
    }

    private File getLogFile(String id) {
        Integer.parseInt(id);
        return new File(TaskLogDao.getTaskLogDir(), "tasklog-" + id + ".txt");
    }

    private static File getTaskLogDir() {
        File homeDir = new File(System.getProperty("cloudsync.home"));
        return new File(homeDir, "tasklogs");
    }

    static /* synthetic */ TaskLog access$000(ResultSet x0) throws SQLException {
        return TaskLogDao.getTaskLog((ResultSet)x0);
    }
}

