/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.duraspace.fcrepo.cloudsync.api.UnauthorizedException;
import org.duraspace.fcrepo.cloudsync.service.dao.AbstractDao;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserDao
extends AbstractDao {
    private static final String ROLE_USER = "ROLE_USER";
    private static final String ROLE_ADMIN = "ROLE_ADMIN";
    private final TransactionTemplate tt;

    public UserDao(JdbcTemplate db, TransactionTemplate tt) {
        super(db);
        this.tt = tt;
    }

    public void initDb() {
        this.db.execute("CREATE TABLE Users (id INTEGER PRIMARY KEY NOT NULL GENERATED BY DEFAULT AS IDENTITY, username VARCHAR(64) NOT NULL, password VARCHAR(64) NOT NULL, enabled BOOLEAN NOT NULL, CONSTRAINT UsersUnique UNIQUE (username))");
        this.db.execute("CREATE TABLE Authorities (username VARCHAR(64) NOT NULL, authority VARCHAR(64) NOT NULL, CONSTRAINT AuthoritiesUnique UNIQUE (username, authority))");
    }

    public org.duraspace.fcrepo.cloudsync.api.User createUser(org.duraspace.fcrepo.cloudsync.api.User user) throws UnauthorizedException {
        org.duraspace.fcrepo.cloudsync.api.User requestingUser = this.getCurrentUser();
        if (requestingUser != null && !requestingUser.isAdmin().booleanValue()) {
            throw new UnauthorizedException("Only admins can create new accounts!");
        }
        this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        return user;
    }

    private void addAuthority(String username, String authority) {
        this.db.update("INSERT INTO Authorities (username, authority) VALUES (?, ?)", new Object[]{username, authority});
    }

    public List<org.duraspace.fcrepo.cloudsync.api.User> listUsers() {
        return this.db.query("SELECT * FROM Users", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public org.duraspace.fcrepo.cloudsync.api.User getUser(String id) {
        return (org.duraspace.fcrepo.cloudsync.api.User)this.db.query("SELECT * FROM Users WHERE id = ?", (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */, new Object[]{Integer.parseInt(id)});
    }

    private org.duraspace.fcrepo.cloudsync.api.User getUser(ResultSet rs) throws SQLException {
        org.duraspace.fcrepo.cloudsync.api.User u = new org.duraspace.fcrepo.cloudsync.api.User();
        u.setId("" + rs.getInt("id"));
        u.setName(rs.getString("username"));
        u.setEnabled(Boolean.valueOf(rs.getBoolean("enabled")));
        u.setAdmin(Boolean.valueOf(this.checkAdmin(u.getName())));
        return u;
    }

    private boolean checkAdmin(String username) {
        return this.db.queryForInt("SELECT COUNT(*) FROM Authorities WHERE username = ? AND authority = ?", new Object[]{username, "ROLE_ADMIN"}) > 0;
    }

    public org.duraspace.fcrepo.cloudsync.api.User getCurrentUser() {
        String userName = UserDao.getCurrentUserName();
        if (userName == null) {
            return null;
        }
        return this.getUser("" + this.getUserId(userName));
    }

    public org.duraspace.fcrepo.cloudsync.api.User updateUser(String id, org.duraspace.fcrepo.cloudsync.api.User user) throws UnauthorizedException {
        org.duraspace.fcrepo.cloudsync.api.User orig = this.getUser(id);
        String hashedPass = null;
        if (user.getId() == null) {
            user.setId(orig.getId());
        }
        if (user.getName() == null) {
            user.setName(orig.getName());
        }
        if (user.isAdmin() == null) {
            user.setAdmin(orig.isAdmin());
        }
        if (user.isEnabled() == null) {
            user.setEnabled(orig.isEnabled());
        }
        if (user.getPassword() != null) {
            ShaPasswordEncoder encoder = new ShaPasswordEncoder();
            hashedPass = encoder.encodePassword(user.getPassword(), null);
        }
        this.checkUpdateUserPermission(user);
        this.replaceUser(user, orig.isAdmin().booleanValue(), hashedPass);
        user.setPassword(null);
        return user;
    }

    private void checkUpdateUserPermission(org.duraspace.fcrepo.cloudsync.api.User user) throws UnauthorizedException {
        org.duraspace.fcrepo.cloudsync.api.User requestingUser = this.getCurrentUser();
        if (requestingUser.isAdmin().booleanValue()) {
            if (requestingUser.getId().equals(user.getId())) {
                if (!user.isEnabled().booleanValue()) {
                    throw new UnauthorizedException("You can't disable your own account!");
                }
                if (!user.isAdmin().booleanValue()) {
                    throw new UnauthorizedException("You can't remove admin privileges from own account!");
                }
            }
        } else if (requestingUser.getId().equals(user.getId())) {
            if (!user.isEnabled().booleanValue()) {
                throw new UnauthorizedException("You can't disable your own account!");
            }
            if (user.isAdmin().booleanValue()) {
                throw new UnauthorizedException("You can't add admin privileges to own account!");
            }
        } else {
            throw new UnauthorizedException("Only admins can modify other accounts!");
        }
    }

    private void replaceUser(org.duraspace.fcrepo.cloudsync.api.User user, boolean wasAdmin, String hashedPass) {
        this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteUser(String id) throws UnauthorizedException {
        org.duraspace.fcrepo.cloudsync.api.User requestingUser = this.getCurrentUser();
        if (!requestingUser.isAdmin().booleanValue()) {
            throw new UnauthorizedException("Only admins can delete accounts!");
        }
        if (requestingUser.getId().equals(id)) {
            throw new UnauthorizedException("You can't delete your own account!");
        }
        String name = this.getUser(id).getName();
        this.tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static String getCurrentUserName() {
        Authentication a = SecurityContextHolder.getContext().getAuthentication();
        if (a == null) {
            return null;
        }
        User u = (User)a.getPrincipal();
        if (u == null) {
            return null;
        }
        return u.getUsername();
    }

    private Integer getUserId(String username) {
        if (username == null) {
            return null;
        }
        return (Integer)this.db.query("SELECT id FROM Users WHERE username = ?", (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */, new Object[]{username});
    }

    static /* synthetic */ void access$000(UserDao x0, String x1, String x2) {
        x0.addAuthority(x1, x2);
    }

    static /* synthetic */ org.duraspace.fcrepo.cloudsync.api.User access$100(UserDao x0, ResultSet x1) throws SQLException {
        return x0.getUser(x1);
    }
}

