/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.ProviderAccount;
import org.duraspace.fcrepo.cloudsync.api.Space;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;

@Path(value="duracloud")
public class DuraCloudResource
extends AbstractResource {
    public static final String PROVIDERACCOUNTS_JSON = "application/vnd.fcrepo-cloudsync.provideraccounts+json";
    public static final String PROVIDERACCOUNTS_XML = "application/vnd.fcrepo-cloudsync.provideraccounts+xml";
    public static final String SPACES_JSON = "application/vnd.fcrepo-cloudsync.spaces+json";
    public static final String SPACES_XML = "application/vnd.fcrepo-cloudsync.spaces+xml";

    public DuraCloudResource(CloudSyncService service) {
        super(service);
    }

    @GET
    @Path(value="/providerAccounts")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.provideraccounts+json", "application/vnd.fcrepo-cloudsync.provideraccounts+xml"})
    @Descriptions(value={@Description(value="Lists the Storage Provider Accounts configured for a DuraCloud Instance", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<ProviderAccount> listProviderAccounts(@QueryParam(value="url") String url, @QueryParam(value="username") String username, @QueryParam(value="password") String password) {
        return this.service.listProviderAccounts(url, username, password);
    }

    @GET
    @Path(value="/spaces")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.spaces+json", "application/vnd.fcrepo-cloudsync.spaces+xml"})
    @Descriptions(value={@Description(value="Lists the Spaces available within a Storage Provider Account on a DuraCloud Instance", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<Space> listSpaces(@QueryParam(value="url") String url, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="providerAccountId") String providerAccountId) {
        return this.service.listSpaces(url, username, password, providerAccountId);
    }
}

