/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.NameConflictException;
import org.duraspace.fcrepo.cloudsync.api.ObjectSet;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;
import org.duraspace.fcrepo.cloudsync.service.util.PATCH;

@Path(value="objectSets")
public class ObjectSetResource
extends AbstractResource {
    public static final String OBJECTSET_JSON = "application/vnd.fcrepo-cloudsync.objectset+json";
    public static final String OBJECTSET_XML = "application/vnd.fcrepo-cloudsync.objectset+xml";
    public static final String OBJECTSETS_JSON = "application/vnd.fcrepo-cloudsync.objectsets+json";
    public static final String OBJECTSETS_XML = "application/vnd.fcrepo-cloudsync.objectsets+xml";

    public ObjectSetResource(CloudSyncService service) {
        super(service);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.objectset+json", "application/vnd.fcrepo-cloudsync.objectset+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectset+json", "application/vnd.fcrepo-cloudsync.objectset+xml"})
    @Descriptions(value={@Description(value="Creates an object set", target="method"), @Description(value="Status: 201 Created", target="response")})
    public Response createObjectSet(@Context UriInfo uriInfo, @Context HttpServletRequest req, ObjectSet objectSet) {
        try {
            ObjectSet newObjectSet = this.service.createObjectSet(objectSet);
            this.setUri(uriInfo, req, newObjectSet);
            return Response.created((URI)newObjectSet.getUri()).entity((Object)newObjectSet).build();
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.objectset+json", "application/vnd.fcrepo-cloudsync.objectset+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectset+json", "application/vnd.fcrepo-cloudsync.objectset+xml"})
    @Descriptions(value={@Description(value="Updates an object set", target="method"), @Description(value="Status: 200 OK", target="response")})
    public ObjectSet updateObjectSet(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id, ObjectSet objectSet) {
        try {
            ObjectSet updatedObjectSet = this.service.updateObjectSet(id, objectSet);
            this.setUri(uriInfo, req, updatedObjectSet);
            return updatedObjectSet;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectsets+json", "application/vnd.fcrepo-cloudsync.objectsets+xml"})
    @Descriptions(value={@Description(value="Lists all object sets", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<ObjectSet> listObjectSets(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        List objectSets = this.service.listObjectSets();
        for (ObjectSet objectSet : objectSets) {
            this.setUri(uriInfo, req, objectSet);
        }
        return objectSets;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectset+json", "application/vnd.fcrepo-cloudsync.objectset+xml"})
    @Descriptions(value={@Description(value="Gets an object set", target="method"), @Description(value="Status: 200 OK", target="response")})
    public ObjectSet getObjectSet(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id) {
        try {
            ObjectSet objectSet = this.service.getObjectSet(id);
            this.setUri(uriInfo, req, objectSet);
            return objectSet;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Descriptions(value={@Description(value="Deletes an object set", target="method"), @Description(value="Status: 204 No Content", target="response")})
    public void deleteObjectSet(@PathParam(value="id") String id) {
        try {
            this.service.deleteObjectSet(id);
        }
        catch (ResourceInUseException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    private void setUri(UriInfo uriInfo, HttpServletRequest req, ObjectSet objectSet) {
        objectSet.setUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("objectSets/" + objectSet.getId())));
        objectSet.setId(null);
    }
}

