/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.NameConflictException;
import org.duraspace.fcrepo.cloudsync.api.ObjectStore;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;

@Path(value="objectStores")
public class ObjectStoreResource
extends AbstractResource {
    public static final String OBJECTSTORE_JSON = "application/vnd.fcrepo-cloudsync.objectstore+json";
    public static final String OBJECTSTORE_XML = "application/vnd.fcrepo-cloudsync.objectstore+xml";
    public static final String OBJECTSTORES_JSON = "application/vnd.fcrepo-cloudsync.objectstores+json";
    public static final String OBJECTSTORES_XML = "application/vnd.fcrepo-cloudsync.objectstores+xml";

    public ObjectStoreResource(CloudSyncService service) {
        super(service);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.objectstore+json", "application/vnd.fcrepo-cloudsync.objectstore+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectstore+json", "application/vnd.fcrepo-cloudsync.objectstore+xml"})
    @Descriptions(value={@Description(value="Creates an object store", target="method"), @Description(value="Status: 201 Created", target="response")})
    public Response createObjectStore(@Context UriInfo uriInfo, @Context HttpServletRequest req, ObjectStore objectStore) {
        try {
            ObjectStore newObjectStore = this.service.createObjectStore(objectStore);
            this.setUri(uriInfo, req, newObjectStore);
            return Response.created((URI)newObjectStore.getUri()).entity((Object)newObjectStore).build();
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectstores+json", "application/vnd.fcrepo-cloudsync.objectstores+xml"})
    @Descriptions(value={@Description(value="Lists all object stores", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<ObjectStore> listObjectStores(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        List objectStores = this.service.listObjectStores();
        for (ObjectStore objectStore : objectStores) {
            this.setUri(uriInfo, req, objectStore);
        }
        return objectStores;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.objectstore+json", "application/vnd.fcrepo-cloudsync.objectstore+xml"})
    @Descriptions(value={@Description(value="Gets an object store", target="method"), @Description(value="Status: 200 OK", target="response")})
    public ObjectStore getObjectStore(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id) {
        try {
            ObjectStore objectStore = this.service.getObjectStore(id);
            this.setUri(uriInfo, req, objectStore);
            return objectStore;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Descriptions(value={@Description(value="Deletes an object store", target="method"), @Description(value="Status: 204 No Content", target="response")})
    public void deleteObjectStore(@PathParam(value="id") String id) {
        try {
            this.service.deleteObjectStore(id);
        }
        catch (ResourceInUseException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    private void setUri(UriInfo uriInfo, HttpServletRequest req, ObjectStore objectStore) {
        objectStore.setUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("objectStores/" + objectStore.getId())));
        objectStore.setId(null);
    }
}

