/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.AlreadyInitializedException;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.ServiceInfo;
import org.duraspace.fcrepo.cloudsync.api.ServiceInit;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;

@Path(value="service")
public class ServiceResource
extends AbstractResource {
    public static final String SERVICEINFO_JSON = "application/vnd.fcrepo-cloudsync.serviceinfo+json";
    public static final String SERVICEINFO_XML = "application/vnd.fcrepo-cloudsync.serviceinfo+xml";
    public static final String SERVICEINIT_JSON = "application/vnd.fcrepo-cloudsync.serviceinit+json";
    public static final String SERVICEINIT_XML = "application/vnd.fcrepo-cloudsync.serviceinit+xml";

    public ServiceResource(CloudSyncService service) {
        super(service);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.serviceinfo+json", "application/vnd.fcrepo-cloudsync.serviceinfo+xml"})
    @Descriptions(value={@Description(value="Gets the Service Info", target="method"), @Description(value="Status: 200 OK", target="response")})
    public ServiceInfo getServiceInfo(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        ServiceInfo serviceInfo = this.service.getServiceInfo();
        serviceInfo.setCurrentUserUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"users/current"));
        serviceInfo.setObjectSetsUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"objectSets"));
        serviceInfo.setObjectStoresUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"objectStores"));
        serviceInfo.setProviderAccountsUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"duracloud/providerAccounts"));
        serviceInfo.setSpacesUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"duracloud/spaces"));
        serviceInfo.setTaskLogsUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"taskLogs"));
        serviceInfo.setTasksUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"tasks"));
        serviceInfo.setUsersUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)"users"));
        return serviceInfo;
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.serviceinit+json", "application/vnd.fcrepo-cloudsync.serviceinit+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.serviceinfo+json", "application/vnd.fcrepo-cloudsync.serviceinfo+xml"})
    @Descriptions(value={@Description(value="Updates the Service Info", target="method"), @Description(value="Status: 200 OK", target="response")})
    public ServiceInfo updateServiceInfo(ServiceInit serviceInit) {
        try {
            return this.service.initialize(serviceInit);
        }
        catch (AlreadyInitializedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }
}

