/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.api.TaskLog;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;

@Path(value="taskLogs")
public class TaskLogResource
extends AbstractResource {
    public static final String TASKLOG_JSON = "application/vnd.fcrepo-cloudsync.tasklog+json";
    public static final String TASKLOG_XML = "application/vnd.fcrepo-cloudsync.tasklog+xml";
    public static final String TASKLOGS_JSON = "application/vnd.fcrepo-cloudsync.tasklogs+json";
    public static final String TASKLOGS_XML = "application/vnd.fcrepo-cloudsync.tasklogs+xml";

    public TaskLogResource(CloudSyncService service) {
        super(service);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.tasklogs+json", "application/vnd.fcrepo-cloudsync.tasklogs+xml"})
    @Descriptions(value={@Description(value="Lists all task logs", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<TaskLog> listTaskLogs(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        List taskLogs = this.service.listTaskLogs();
        for (TaskLog taskLog : taskLogs) {
            this.setUris(uriInfo, req, taskLog);
        }
        return taskLogs;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.tasklog+json", "application/vnd.fcrepo-cloudsync.tasklog+xml"})
    @Descriptions(value={@Description(value="Gets a task log", target="method"), @Description(value="Status: 200 OK", target="response")})
    public TaskLog getTaskLog(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id) {
        try {
            TaskLog taskLog = this.service.getTaskLog(id);
            this.setUris(uriInfo, req, taskLog);
            return taskLog;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{id}/content")
    @Produces(value={"text/plain"})
    @Descriptions(value={@Description(value="Gets a task log's content", target="method"), @Description(value="Status: 200 OK", target="response")})
    public InputStream getTaskLogContent(@PathParam(value="id") String id) {
        try {
            return this.service.getTaskLogContent(id);
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Descriptions(value={@Description(value="Deletes a task log", target="method"), @Description(value="Status: 204 No Content", target="response")})
    public void deleteTaskLog(@PathParam(value="id") String id) {
        try {
            this.service.deleteTaskLog(id);
        }
        catch (ResourceInUseException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    private void setUris(UriInfo uriInfo, HttpServletRequest req, TaskLog taskLog) {
        URI uri = URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("taskLogs/" + taskLog.getId()));
        taskLog.setUri(uri);
        taskLog.setTaskUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("tasks/" + taskLog.getTaskId())));
        taskLog.setContentUri(URI.create(uri + "/content"));
        taskLog.setId(null);
        taskLog.setTaskId(null);
    }
}

