/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.NameConflictException;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.api.Task;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;
import org.duraspace.fcrepo.cloudsync.service.util.PATCH;

@Path(value="tasks")
public class TaskResource
extends AbstractResource {
    public static final String TASK_JSON = "application/vnd.fcrepo-cloudsync.task+json";
    public static final String TASK_XML = "application/vnd.fcrepo-cloudsync.task+xml";
    public static final String TASKS_JSON = "application/vnd.fcrepo-cloudsync.tasks+json";
    public static final String TASKS_XML = "application/vnd.fcrepo-cloudsync.tasks+xml";

    public TaskResource(CloudSyncService service) {
        super(service);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.task+json", "application/vnd.fcrepo-cloudsync.task+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.task+json", "application/vnd.fcrepo-cloudsync.task+xml"})
    @Descriptions(value={@Description(value="Creates a task", target="method"), @Description(value="Status: 201 Created", target="response")})
    public Response createTask(@Context UriInfo uriInfo, @Context HttpServletRequest req, Task task) {
        try {
            Task newTask = this.service.createTask(task);
            this.setUris(uriInfo, req, newTask);
            return Response.created((URI)newTask.getUri()).entity((Object)newTask).build();
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.tasks+json", "application/vnd.fcrepo-cloudsync.tasks+xml"})
    @Descriptions(value={@Description(value="Lists all tasks", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<Task> listTasks(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        List tasks = this.service.listTasks();
        for (Task task : tasks) {
            this.setUris(uriInfo, req, task);
        }
        return tasks;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.task+json", "application/vnd.fcrepo-cloudsync.task+xml"})
    @Descriptions(value={@Description(value="Gets a task", target="method"), @Description(value="Status: 200 OK", target="response")})
    public Task getTask(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id) {
        try {
            Task task = this.service.getTask(id);
            this.setUris(uriInfo, req, task);
            return task;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.task+json", "application/vnd.fcrepo-cloudsync.task+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.task+json", "application/vnd.fcrepo-cloudsync.task+xml"})
    @Descriptions(value={@Description(value="Updates a task", target="method"), @Description(value="Status: 200 OK", target="response")})
    public Task updateTask(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id, Task task) {
        try {
            Task updatedTask = this.service.updateTask(id, task);
            this.setUris(uriInfo, req, updatedTask);
            return updatedTask;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Descriptions(value={@Description(value="Deletes a task", target="method"), @Description(value="Status: 204 No Content", target="response")})
    public void deleteTask(@PathParam(value="id") String id) {
        try {
            this.service.deleteTask(id);
        }
        catch (ResourceInUseException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    private void setUris(UriInfo uriInfo, HttpServletRequest req, Task task) {
        task.setUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("tasks/" + task.getId())));
        if (task.getActiveLogId() != null && !task.getActiveLogId().equals("0")) {
            task.setActiveLogUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("taskLogs/" + task.getActiveLogId())));
        }
        task.setActiveLogId(null);
        task.setId(null);
    }
}

