/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.rest;

import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.duraspace.fcrepo.cloudsync.api.CloudSyncService;
import org.duraspace.fcrepo.cloudsync.api.NameConflictException;
import org.duraspace.fcrepo.cloudsync.api.ResourceInUseException;
import org.duraspace.fcrepo.cloudsync.api.ResourceNotFoundException;
import org.duraspace.fcrepo.cloudsync.api.UnauthorizedException;
import org.duraspace.fcrepo.cloudsync.api.User;
import org.duraspace.fcrepo.cloudsync.service.rest.AbstractResource;
import org.duraspace.fcrepo.cloudsync.service.rest.URIMapper;
import org.duraspace.fcrepo.cloudsync.service.util.PATCH;

@Path(value="users")
public class UserResource
extends AbstractResource {
    public static final String USER_JSON = "application/vnd.fcrepo-cloudsync.user+json";
    public static final String USER_XML = "application/vnd.fcrepo-cloudsync.user+xml";
    public static final String USERS_JSON = "application/vnd.fcrepo-cloudsync.users+json";
    public static final String USERS_XML = "application/vnd.fcrepo-cloudsync.users+xml";

    public UserResource(CloudSyncService service) {
        super(service);
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.user+json", "application/vnd.fcrepo-cloudsync.user+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.user+json", "application/vnd.fcrepo-cloudsync.user+xml"})
    @Descriptions(value={@Description(value="Creates a user", target="method"), @Description(value="Status: 201 Created", target="response")})
    public Response createUser(@Context UriInfo uriInfo, @Context HttpServletRequest req, User user) {
        try {
            User newUser = this.service.createUser(user);
            this.setUri(uriInfo, req, newUser);
            return Response.created((URI)user.getUri()).entity((Object)newUser).build();
        }
        catch (UnauthorizedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.users+json", "application/vnd.fcrepo-cloudsync.users+xml"})
    @Descriptions(value={@Description(value="Lists all users", target="method"), @Description(value="Status: 200 OK", target="response")})
    public List<User> listUsers(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        List users = this.service.listUsers();
        for (User user : users) {
            this.setUri(uriInfo, req, user);
        }
        return users;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.user+json", "application/vnd.fcrepo-cloudsync.user+xml"})
    @Descriptions(value={@Description(value="Gets a user", target="method"), @Description(value="Status: 200 OK", target="response")})
    public User getUser(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id) {
        try {
            User user = this.service.getUser(id);
            this.setUri(uriInfo, req, user);
            return user;
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="current")
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.user+json", "application/vnd.fcrepo-cloudsync.user+xml"})
    @Descriptions(value={@Description(value="Gets the currently logged in user", target="method"), @Description(value="Status: 200 OK", target="response")})
    public Response getCurrentUser(@Context UriInfo uriInfo, @Context HttpServletRequest req) {
        User user = this.service.getCurrentUser();
        this.setUri(uriInfo, req, user);
        return Response.ok((Object)user).contentLocation(user.getUri()).build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/vnd.fcrepo-cloudsync.user+json", "application/vnd.fcrepo-cloudsync.user+xml"})
    @Produces(value={"application/json", "application/xml", "application/vnd.fcrepo-cloudsync.user+json", "application/vnd.fcrepo-cloudsync.user+xml"})
    @Descriptions(value={@Description(value="Updates a user", target="method"), @Description(value="Status: 200 OK", target="response")})
    public User updateUser(@Context UriInfo uriInfo, @Context HttpServletRequest req, @PathParam(value="id") String id, User user) {
        try {
            User updatedUser = this.service.updateUser(id, user);
            this.setUri(uriInfo, req, updatedUser);
            return updatedUser;
        }
        catch (UnauthorizedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (NameConflictException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    @DELETE
    @Path(value="{id}")
    @Descriptions(value={@Description(value="Deletes a user", target="method"), @Description(value="Status: 204 No Content", target="response")})
    public void deleteUser(@PathParam(value="id") String id) {
        try {
            this.service.deleteUser(id);
        }
        catch (UnauthorizedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.FORBIDDEN);
        }
        catch (ResourceInUseException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.CONFLICT);
        }
    }

    private void setUri(UriInfo uriInfo, HttpServletRequest req, User user) {
        user.setUri(URIMapper.getUri((UriInfo)uriInfo, (HttpServletRequest)req, (String)("users/" + user.getId())));
        user.setId(null);
    }
}

