/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.fcrepo.cloudsync.service.util;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StringUtil {
    private StringUtil() {
    }

    public static String normalize(String val) {
        if (val == null || val.trim().length() == 0) {
            return null;
        }
        return val.trim();
    }

    public static String validate(String name, String value, int maxLen) throws IllegalArgumentException {
        String normVal = StringUtil.normalize((String)value);
        if (normVal == null) {
            throw new IllegalArgumentException("A value must be specified for '" + name + "'");
        }
        if (normVal.length() > maxLen) {
            throw new IllegalArgumentException("The value specified for '" + name + "' was too long. It must not exceed" + " " + maxLen + " characters.");
        }
        return normVal;
    }

    public static String validate(String name, String value, String[] validValues) throws IllegalArgumentException {
        String normVal = StringUtil.validate((String)name, (String)value, (int)Integer.MAX_VALUE);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < validValues.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append("'");
            s.append(validValues[i]);
            s.append("'");
            if (!normVal.equals(validValues[i])) continue;
            return normVal;
        }
        throw new IllegalArgumentException("One of the following values must be specified for '" + name + "': [ " + s.toString() + " ]");
    }

    public static String validate(String name, String value) throws IllegalArgumentException {
        return StringUtil.validate((String)name, (String)value, (int)Integer.MAX_VALUE);
    }

    public static String validateInt(String name, String value) throws IllegalArgumentException {
        String normVal = StringUtil.validate((String)name, (String)value, (int)Integer.MAX_VALUE);
        try {
            Integer.parseInt(normVal);
            return normVal;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Non-integer specified for '" + name + "'");
        }
    }
}

