/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.ruleengine;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.dvare.annotations.After;
import org.dvare.annotations.Before;
import org.dvare.annotations.Condition;
import org.dvare.annotations.ConditionType;
import org.dvare.annotations.Fail;
import org.dvare.annotations.Rule;
import org.dvare.annotations.Success;
import org.dvare.exceptions.rule.ConditionNotFoundException;
import org.dvare.exceptions.rule.ConditionParamNotFoundException;
import org.dvare.ruleengine.ConditionStructure;
import org.dvare.ruleengine.MethodStructure;
import org.dvare.ruleengine.RuleStructure;
import org.dvare.ruleengine.TextualRuleEngine;

class AnnotatedRuleParser {
    AnnotatedRuleParser() {
    }

    RuleStructure parseRule(Object rule, int size) {
        Rule ruleDetails = rule.getClass().getAnnotation(Rule.class);
        String ruleId = ruleDetails.name() + size;
        if (rule.getClass().isAnnotationPresent(Rule.class)) {
            Rule ruleDetail = rule.getClass().getAnnotation(Rule.class);
            RuleStructure ruleStructure = new RuleStructure();
            ruleStructure.ruleId = ruleId;
            ruleStructure.rule = rule;
            ruleStructure.priority = ruleDetail.priority();
            for (Method method : rule.getClass().getMethods()) {
                MethodStructure methodStructure;
                if (method.isAnnotationPresent(Condition.class)) {
                    Condition condition = method.getAnnotation(Condition.class);
                    ConditionStructure conditionStructure = new ConditionStructure();
                    conditionStructure.order = condition.order();
                    conditionStructure.condition = method;
                    conditionStructure.conditionType = condition.type();
                    ruleStructure.conditions.add(conditionStructure);
                    continue;
                }
                if (method.isAnnotationPresent(Before.class)) {
                    Before before = method.getAnnotation(Before.class);
                    methodStructure = new MethodStructure();
                    methodStructure.order = before.order();
                    methodStructure.method = method;
                    ruleStructure.beforeMethods.add(methodStructure);
                    continue;
                }
                if (method.isAnnotationPresent(After.class)) {
                    After after = method.getAnnotation(After.class);
                    methodStructure = new MethodStructure();
                    methodStructure.order = after.order();
                    methodStructure.method = method;
                    ruleStructure.afterMethods.add(methodStructure);
                    continue;
                }
                if (method.isAnnotationPresent(Success.class)) {
                    Success success = method.getAnnotation(Success.class);
                    methodStructure = new MethodStructure();
                    methodStructure.order = success.order();
                    methodStructure.method = method;
                    ruleStructure.successMethods.add(methodStructure);
                    continue;
                }
                if (!method.isAnnotationPresent(Fail.class)) continue;
                Fail fail = method.getAnnotation(Fail.class);
                methodStructure = new MethodStructure();
                methodStructure.order = fail.order();
                methodStructure.method = method;
                ruleStructure.failMethods.add(methodStructure);
            }
            return ruleStructure;
        }
        return null;
    }

    void validateRule(Object rule) throws ConditionNotFoundException, ConditionParamNotFoundException {
        boolean conditionFound = false;
        for (Method method : rule.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Condition.class)) continue;
            Condition condition = method.getAnnotation(Condition.class);
            ConditionType conditionType = condition.type();
            if (!method.getReturnType().equals(Boolean.class) && !method.getReturnType().equals(Boolean.TYPE)) {
                throw new ConditionNotFoundException("Method with Condition Type Code must return Boolean value ");
            }
            if (conditionType.equals((Object)ConditionType.TEXT)) {
                if (method.getParameters() != null && method.getParameters().length > 0) {
                    Parameter parameter = method.getParameters()[0];
                    if (!parameter.getType().equals(TextualRuleEngine.class)) {
                        throw new ConditionParamNotFoundException("Method Condition Type DVARE not contain TextualRuleEngine param");
                    }
                } else {
                    throw new ConditionParamNotFoundException("Method Condition Type DVARE not contain TextualRuleEngine param ");
                }
            }
            conditionFound = true;
        }
        if (!conditionFound) {
            throw new ConditionNotFoundException("Passed RuleBinding not contain any  Method  annotated with @Condition");
        }
    }
}

