/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.ruleengine;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dvare.annotations.ConditionType;
import org.dvare.annotations.Rule;
import org.dvare.exceptions.rule.IllegalRuleException;
import org.dvare.rule.BasicRule;
import org.dvare.rule.TextualRule;
import org.dvare.ruleengine.AnnotatedRuleParser;
import org.dvare.ruleengine.ConditionStructure;
import org.dvare.ruleengine.MethodStructure;
import org.dvare.ruleengine.RuleParser;
import org.dvare.ruleengine.RuleResult;
import org.dvare.ruleengine.RuleStructure;
import org.dvare.ruleengine.TextualRuleEngine;

public class RuleEngine {
    Logger logger = Logger.getLogger(RuleEngine.class);
    private Integer satisfyCondition = 0;
    private Boolean stopOnFail = false;
    private TextualRuleEngine textualRuleEngine;
    private List<RuleResult> ruleResults;
    private Map<String, RuleStructure> rules = new HashMap<String, RuleStructure>();

    public RuleEngine(TextualRuleEngine textualRuleEngine) {
        this.textualRuleEngine = textualRuleEngine;
    }

    public String registerRule(Object rule) throws IllegalRuleException {
        if (rule == null) {
            throw new IllegalRuleException("Passed Rule is null");
        }
        RuleStructure ruleStructure = null;
        if (rule.getClass().isAnnotationPresent(Rule.class)) {
            AnnotatedRuleParser annotatedRuleParser = new AnnotatedRuleParser();
            annotatedRuleParser.validateRule(rule);
            ruleStructure = annotatedRuleParser.parseRule(rule, this.rules.values().size());
        } else if (rule instanceof BasicRule || rule instanceof TextualRule) {
            RuleParser ruleParser = new RuleParser();
            ruleStructure = ruleParser.parseRule(rule, this.rules.values().size());
        } else {
            throw new IllegalRuleException("Passed Rule Must be Annotated with @Rule or implement BasicRule or TextualRule");
        }
        this.rules.put(ruleStructure.ruleId, ruleStructure);
        return ruleStructure.ruleId;
    }

    public void unregisterRule(String ruleId) {
        if (this.rules.containsKey(ruleId)) {
            this.rules.remove(ruleId);
        }
    }

    public Object getRule(String ruleId) {
        if (this.rules.containsKey(ruleId)) {
            return this.rules.get((Object)ruleId).rule;
        }
        return null;
    }

    public List<Object> getRules() {
        return new ArrayList<Object>(this.rules.values());
    }

    public void clearRules() {
        this.rules.clear();
    }

    public Map<String, Boolean> fireRules() {
        this.ruleResults = new ArrayList<RuleResult>();
        ArrayList<RuleStructure> ruleSet = new ArrayList<RuleStructure>(this.rules.values());
        Collections.sort(ruleSet);
        for (RuleStructure rule : ruleSet) {
            try {
                Boolean result = this.triggerConditions(rule);
                this.triggerListener(rule, result);
                RuleResult ruleResult = new RuleResult();
                ruleResult.setRuleId(rule.ruleId);
                ruleResult.setRule(rule.rule);
                ruleResult.setResult(result);
                this.ruleResults.add(ruleResult);
                if (!this.stopOnFail.booleanValue() || result.booleanValue()) continue;
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (RuleResult ruleResult : this.ruleResults) {
            result.put(ruleResult.getRuleId(), ruleResult.getResult());
        }
        return result;
    }

    public List<RuleResult> getResults() {
        return this.ruleResults;
    }

    private void triggerBefore(RuleStructure rule) throws IllegalAccessException, InvocationTargetException {
        List<MethodStructure> beforeMethods = rule.beforeMethods;
        Collections.sort(beforeMethods);
        for (MethodStructure methodStructure : beforeMethods) {
            methodStructure.method.invoke(rule.rule, new Object[0]);
        }
    }

    private void triggerAfter(RuleStructure rule) throws IllegalAccessException, InvocationTargetException {
        List<MethodStructure> afterMethods = rule.afterMethods;
        Collections.sort(afterMethods);
        for (MethodStructure methodStructure : afterMethods) {
            methodStructure.method.invoke(rule.rule, new Object[0]);
        }
    }

    private Boolean triggerConditions(RuleStructure rule) throws IllegalAccessException, InvocationTargetException {
        block7: {
            ArrayList<Boolean> results;
            block6: {
                List<ConditionStructure> conditions = rule.conditions;
                Collections.sort(conditions);
                results = new ArrayList<Boolean>();
                for (ConditionStructure conditionStructure : conditions) {
                    this.triggerBefore(rule);
                    Object conditionResult = null;
                    if (conditionStructure.conditionType.equals((Object)ConditionType.CODE)) {
                        conditionResult = conditionStructure.condition.invoke(rule.rule, new Object[0]);
                    } else if (conditionStructure.conditionType.equals((Object)ConditionType.TEXT)) {
                        conditionResult = conditionStructure.condition.invoke(rule.rule, this.textualRuleEngine);
                    }
                    this.triggerAfter(rule);
                    if (!(conditionResult instanceof Boolean)) continue;
                    Boolean booleanResult = (Boolean)conditionResult;
                    results.add(booleanResult);
                }
                if (!this.satisfyCondition.equals(0)) break block6;
                for (Boolean result : results) {
                    if (!result.booleanValue()) continue;
                    return true;
                }
                break block7;
            }
            if (!this.satisfyCondition.equals(1)) break block7;
            for (Boolean result : results) {
                if (result.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private void triggerListener(RuleStructure rule, Boolean result) throws IllegalAccessException, InvocationTargetException {
        if (result.booleanValue()) {
            List<MethodStructure> successMethods = rule.successMethods;
            Collections.sort(successMethods);
            for (MethodStructure methodStructure : successMethods) {
                methodStructure.method.invoke(rule.rule, new Object[0]);
            }
        } else {
            List<MethodStructure> failMethods = rule.failMethods;
            Collections.sort(failMethods);
            for (MethodStructure methodStructure : failMethods) {
                methodStructure.method.invoke(rule.rule, new Object[0]);
            }
        }
    }

    public void setSatisfyCondition(Integer satisfyCondition) {
        this.satisfyCondition = satisfyCondition;
    }

    public void setStopOnFail(Boolean stopOnFail) {
        this.stopOnFail = stopOnFail;
    }
}

