/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.ruleengine;

import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.dvare.annotations.ConditionType;
import org.dvare.rule.BasicRule;
import org.dvare.rule.TextualRule;
import org.dvare.ruleengine.ConditionStructure;
import org.dvare.ruleengine.MethodStructure;
import org.dvare.ruleengine.RuleStructure;
import org.dvare.ruleengine.TextualRuleEngine;

class RuleParser {
    RuleParser() {
    }

    RuleStructure parseRule(Object rule, int size) {
        try {
            ConditionStructure conditionStructure;
            Method condition;
            Object name = MethodUtils.invokeExactMethod((Object)rule, (String)"getName");
            Object priorityObject = MethodUtils.invokeExactMethod((Object)rule, (String)"priority");
            Integer priority = 0;
            if (priorityObject != null) {
                priority = (Integer)priorityObject;
            }
            String ruleId = null;
            ruleId = name != null ? (String)name + size : "" + size;
            RuleStructure ruleStructure = new RuleStructure();
            ruleStructure.ruleId = ruleId;
            ruleStructure.rule = rule;
            ruleStructure.priority = priority;
            Method before = MethodUtils.getAccessibleMethod(rule.getClass(), (String)"before", (Class[])new Class[0]);
            MethodStructure beforeStructure = new MethodStructure();
            beforeStructure.order = 0;
            beforeStructure.method = before;
            ruleStructure.beforeMethods.add(beforeStructure);
            if (rule instanceof BasicRule) {
                condition = MethodUtils.getAccessibleMethod(rule.getClass(), (String)"condition", (Class[])new Class[0]);
                conditionStructure = new ConditionStructure();
                conditionStructure.order = 0;
                conditionStructure.conditionType = ConditionType.CODE;
                conditionStructure.condition = condition;
                ruleStructure.conditions.add(conditionStructure);
            } else if (rule instanceof TextualRule) {
                condition = MethodUtils.getAccessibleMethod(rule.getClass(), (String)"condition", (Class[])new Class[]{TextualRuleEngine.class});
                conditionStructure = new ConditionStructure();
                conditionStructure.order = 0;
                conditionStructure.conditionType = ConditionType.TEXT;
                conditionStructure.condition = condition;
                ruleStructure.conditions.add(conditionStructure);
            }
            Method after = MethodUtils.getAccessibleMethod(rule.getClass(), (String)"after", (Class[])new Class[0]);
            MethodStructure afterStructure = new MethodStructure();
            afterStructure.order = 0;
            afterStructure.method = after;
            ruleStructure.afterMethods.add(afterStructure);
            Method success = MethodUtils.getAccessibleMethod(rule.getClass(), (String)"success", (Class[])new Class[0]);
            MethodStructure successStructure = new MethodStructure();
            successStructure.order = 0;
            successStructure.method = success;
            ruleStructure.afterMethods.add(successStructure);
            Method fail = MethodUtils.getAccessibleMethod(rule.getClass(), (String)"fail", (Class[])new Class[0]);
            MethodStructure failStructure = new MethodStructure();
            failStructure.order = 0;
            failStructure.method = fail;
            ruleStructure.afterMethods.add(failStructure);
            return ruleStructure;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

