/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.ruleengine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.log4j.Logger;
import org.dvare.binding.model.TypeBinding;
import org.dvare.binding.rule.RuleBinding;
import org.dvare.config.RuleConfiguration;
import org.dvare.exceptions.interpreter.InterpretException;
import org.dvare.expression.Expression;

public class TextualRuleEngine {
    Logger logger = Logger.getLogger(TextualRuleEngine.class);
    RuleConfiguration configuration;

    public TextualRuleEngine(RuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean evaluate(File rulefile, Class type, Object object) {
        try {
            String row;
            BufferedReader br = new BufferedReader(new FileReader(rulefile));
            StringBuilder rule = new StringBuilder();
            while ((row = br.readLine()) != null) {
                rule.append(row.trim());
                rule.append(" ");
            }
            return this.evaluate(rule.toString(), type, object);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean evaluate(String rule, TypeBinding typeBinding, Object object) {
        try {
            Expression expression = this.configuration.getParser().fromString(rule, typeBinding);
            RuleBinding ruleExpression = new RuleBinding(expression);
            ruleExpression.setRawExpression(rule);
            return this.evaluate(ruleExpression, object);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean evaluate(String rule, Class type, Object object) {
        try {
            Expression expression = this.configuration.getParser().fromString(rule, type);
            RuleBinding ruleExpression = new RuleBinding(expression);
            ruleExpression.setRawExpression(rule);
            return this.evaluate(ruleExpression, object);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean evaluate(RuleBinding rule, Object object) throws InterpretException {
        boolean result = this.configuration.getEvaluator().evaluate(rule, object);
        return result;
    }
}

