package org.dvare.rest.api;


import org.apache.commons.cli.*;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;

public class App {

    public static void main(String[] args) throws Exception {

        Options options = new Options();


        Option option = new Option("port", true, "server port");
        option.setArgs(1);
        options.addOption(option);

        options.addOption(option);

        CommandLineParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);

        Server server = null;
        if (cmd.hasOption("port")) {
            String port = cmd.getOptionValue("port", "8080");
            if (port != null) {
                server = new Server(Integer.parseInt(port));
            }
        } else {

            String port = System.getProperty("server.port");
            if (port != null) {
                server = new Server(Integer.parseInt(port));
            } else {
                System.exit(1);
            }

        }
        ServletHolder servlet = new ServletHolder(new ServletContainer(new ApplicationConfig()));


        ServletContextHandler context = new ServletContextHandler(server, "/*");
        context.addServlet(servlet, "/api/*");

        HashSessionIdManager idmanager = new HashSessionIdManager();
        server.setSessionIdManager(idmanager);


        // Create the SessionHandler (wrapper) to handle the sessions
        HashSessionManager manager = new HashSessionManager();
        SessionHandler sessions = new SessionHandler(manager);
        context.setSessionHandler(sessions);


        try {
            server.start();
            server.join();
        } finally {
            server.destroy();
        }


    }
}
