/*
 * Decompiled with CFR 0.152.
 */
package org.dvare.spring.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dvare.api.RuleEngineBuilder;
import org.dvare.exceptions.rule.IllegalRuleException;
import org.dvare.ruleengine.RuleEngine;
import org.springframework.beans.factory.FactoryBean;

public class RulesEngineFactoryBean
implements FactoryBean<RuleEngine> {
    Logger logger = Logger.getLogger(RulesEngineFactoryBean.class);
    private String[] functionPackages;
    private Integer satisfyCondition = 0;
    private Boolean stopOnFail = false;
    private List<Object> rules = new ArrayList<Object>();

    public RuleEngine getObject() throws Exception {
        RuleEngineBuilder ruleEngineBuilder = new RuleEngineBuilder();
        ruleEngineBuilder.functionPackages(this.functionPackages);
        ruleEngineBuilder.satisfyCondition(this.satisfyCondition);
        ruleEngineBuilder.stopOnFail(Boolean.valueOf(false));
        RuleEngine ruleEngine = ruleEngineBuilder.build();
        this.registerRules(ruleEngine);
        return ruleEngine;
    }

    private void registerRules(RuleEngine ruleEngine) {
        if (this.rules != null && !this.rules.isEmpty()) {
            for (Object rule : this.rules) {
                try {
                    ruleEngine.registerRule(rule);
                }
                catch (IllegalRuleException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Class<RuleEngine> getObjectType() {
        return RuleEngine.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public Integer getSatisfyCondition() {
        return this.satisfyCondition;
    }

    public void setSatisfyCondition(Integer satisfyCondition) {
        this.satisfyCondition = satisfyCondition;
    }

    public String[] getFunctionPackages() {
        return this.functionPackages;
    }

    public void setFunctionPackages(String[] functionPackages) {
        this.functionPackages = functionPackages;
    }

    public Boolean getStopOnFail() {
        return this.stopOnFail;
    }

    public void setStopOnFail(Boolean stopOnFail) {
        this.stopOnFail = stopOnFail;
    }

    public List<Object> getRules() {
        return this.rules;
    }

    public void setRules(List<Object> rules) {
        this.rules = rules;
    }
}

