/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj;

import com.basis.startup.type.BBjException;
import java.util.Map;
import org.dwcj.Environment;
import org.dwcj.annotations.AnnotationProcessor;
import org.dwcj.environment.namespace.GlobalNamespace;
import org.dwcj.environment.namespace.GroupNamespace;
import org.dwcj.environment.namespace.Namespace;
import org.dwcj.environment.namespace.PrivateNamespace;
import org.dwcj.environment.namespace.SessionNamespace;
import org.dwcj.exceptions.DwcException;
import org.dwcj.exceptions.DwcRuntimeException;

public abstract class App {
    protected App() {
        this.preRun();
        try {
            AnnotationProcessor processor = new AnnotationProcessor();
            processor.processAppAnnotations(this, AnnotationProcessor.RunningPhase.PRE_RUN);
            this.run();
            processor.processAppAnnotations(this, AnnotationProcessor.RunningPhase.POST_RUN);
        }
        catch (DwcException e) {
            Environment.logError(e);
        }
    }

    public static void setTitle(String title) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setTitle(title);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set title.", e);
        }
    }

    public static String getTitle() {
        try {
            return Environment.getInstance().getBBjAPI().getWebManager().getTitle();
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to get title.", e);
        }
    }

    public static String getApplicationName() {
        try {
            return Environment.getInstance().getBBjAPI().getWebManager().getApplicationName();
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to get application name.", e);
        }
    }

    public static void setTheme(String theme) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setTheme(theme);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set theme.", e);
        }
    }

    public static void setTheme(Theme theme) {
        App.setTheme(theme.getValue());
    }

    public static String getTheme() {
        try {
            return Environment.getInstance().getBBjAPI().getWebManager().getTheme();
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to get theme.", e);
        }
    }

    public static void setDarkTheme(String darkTheme) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setDarkTheme(darkTheme);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set dark theme.", e);
        }
    }

    public static String getDarkTheme() {
        try {
            return Environment.getInstance().getBBjAPI().getWebManager().getDarkTheme();
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to get dark theme.", e);
        }
    }

    public static void setLightTheme(String lightTheme) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setLightTheme(lightTheme);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set light theme.", e);
        }
    }

    public static String getLightTheme() {
        try {
            return Environment.getInstance().getBBjAPI().getWebManager().getLightTheme();
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to get light theme.", e);
        }
    }

    public static void setMeta(String name, String content, Map<String, String> attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setMeta(name, content, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set meta tag.", e);
        }
    }

    public static void setMeta(String name, String content, String attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setMeta(name, content, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set meta tag.", e);
        }
    }

    public static void setMeta(String name, String content) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setMeta(name, content);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set meta tag.", e);
        }
    }

    public static void setAttribute(String name, String value, String selector) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().setAttribute(name, value, selector);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to set attribute.", e);
        }
    }

    public static void setAttribute(String name, String value) {
        App.setAttribute(name, value, "");
    }

    public static void setAttribute(String name) {
        App.setAttribute(name, name, "");
    }

    public static String getAttribute(String name, String selector) {
        try {
            return Environment.getInstance().getBBjAPI().getWebManager().getAttribute(name, selector);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to get attribute.", e);
        }
    }

    public static String getAttribute(String name) {
        return App.getAttribute(name, "");
    }

    public static void addStyleSheet(String url, boolean top, Map<String, String> attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectStyleUrl(url, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add stylesheet.", e);
        }
    }

    public static void addStyleSheet(String url, boolean top, String attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectStyleUrl(url, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add stylesheet.", e);
        }
    }

    public static void addStyleSheet(String url, boolean top) {
        App.addStyleSheet(url, top, "");
    }

    public static void addStyleSheet(String url) {
        App.addStyleSheet(url, false, "");
    }

    public static void addInlineStyleSheet(String css, boolean top, Map<String, String> attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectStyle(css, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add inline stylesheet.", e);
        }
    }

    public static void addInlineStyleSheet(String css, boolean top, String attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectStyle(css, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add inline stylesheet.", e);
        }
    }

    public static void addInlineStyleSheet(String css, boolean top) {
        App.addInlineStyleSheet(css, top, "");
    }

    public static void addInlineStyleSheet(String css) {
        App.addInlineStyleSheet(css, false, "");
    }

    public static void addJavaScript(String url, boolean top, Map<String, String> attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectScriptUrl(url, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add script.", e);
        }
    }

    public static void addJavaScript(String url, boolean top, String attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectScriptUrl(url, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add script.", e);
        }
    }

    public static void addJavaScript(String url, boolean top) {
        App.addJavaScript(url, top, "");
    }

    public static void addJavaScript(String url) {
        App.addJavaScript(url, false, "");
    }

    public static void addInlineJavaScript(String script, boolean top, Map<String, String> attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectScript(script, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add inline script.", e);
        }
    }

    public static void addInlineJavaScript(String script, boolean top, String attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectScript(script, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add inline script.", e);
        }
    }

    public static void addInlineJavaScript(String script, boolean top) {
        App.addInlineJavaScript(script, top, "");
    }

    public static void addInlineJavaScript(String script) {
        App.addInlineJavaScript(script, false, "");
    }

    public static void addLink(String url, boolean top, Map<String, String> attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectLinkUrl(url, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add link.", e);
        }
    }

    public static void addLink(String url, boolean top, String attributes) {
        try {
            Environment.getInstance().getBBjAPI().getWebManager().injectLinkUrl(url, top, attributes);
        }
        catch (BBjException e) {
            throw new DwcRuntimeException("Failed to add link.", e);
        }
    }

    public static void addLink(String url, boolean top) {
        App.addLink(url, top, "");
    }

    public static void addLink(String url) {
        App.addLink(url, false, "");
    }

    public static void consoleLog(String output) {
        try {
            Environment.getInstance().getSysGui().executeScript("console.log(\"" + output + "\")");
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public static void consoleError(String output) {
        try {
            Environment.getInstance().getSysGui().executeScript("console.error(\"" + output + "\")");
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }

    public static int msgbox(String alert) {
        return Environment.getInstance().getDwcjHelper().msgbox(alert, 0, "");
    }

    public static int msgbox(String alert, int options) {
        return Environment.getInstance().getDwcjHelper().msgbox(alert, options, "");
    }

    public static int msgbox(String alert, int options, String title) {
        return Environment.getInstance().getDwcjHelper().msgbox(alert, options, title);
    }

    public static void busy(boolean busy) {
        try {
            if (busy) {
                Environment.getInstance().getBBjAPI().getBuiManager().getBusyIndicator().setText("");
            }
            Environment.getInstance().getBBjAPI().getBuiManager().getBusyIndicator().setVisible(busy);
        }
        catch (BBjException bBjException) {
            // empty catch block
        }
    }

    public static void busy(String busyText) {
        try {
            Environment.getInstance().getBBjAPI().getBuiManager().getBusyIndicator().setText(busyText);
            Environment.getInstance().getBBjAPI().getBuiManager().getBusyIndicator().setVisible(true);
        }
        catch (BBjException bBjException) {
            // empty catch block
        }
    }

    private void preRun() {
        Environment.getInstance().getBBjAPI().setCustomEventCallback("doTerminate", "terminate");
    }

    public void terminate() {
        Environment.getInstance().getBBjAPI().postPriorityCustomEvent("doTerminate", null);
        this.cleanup();
        Environment.cleanup();
    }

    public void cleanup() {
    }

    public abstract void run() throws DwcException;

    public static Namespace getNamespace(Namespace.NamespaceType namespaceType) {
        switch (namespaceType) {
            case PRIVATE: {
                throw new IllegalArgumentException("PRIVATE namespaces have a prefix and a name!");
            }
            case SESSION: {
                return new SessionNamespace();
            }
            case GROUP: {
                return new GroupNamespace();
            }
            case GLOBAL: {
                return new GlobalNamespace();
            }
        }
        throw new IllegalArgumentException("Illegal Type!");
    }

    public static Namespace getNamespace(String prefix, String name, Boolean fCreateIfMissing) {
        if (prefix.isBlank() || name.isBlank()) {
            throw new IllegalArgumentException("You need a prefix and a name here");
        }
        return new PrivateNamespace(prefix, name, fCreateIfMissing);
    }

    public static enum Theme {
        LIGHT("light"),
        DARK("dark"),
        DARK_PURE("dark-pure"),
        SYSTEM("system");

        private String value;

        private Theme(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

