/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj;

import com.basis.bbj.proxies.BBjAPI;
import com.basis.bbj.proxies.BBjSysGui;
import com.basis.startup.type.BBjException;
import java.util.HashMap;
import org.dwcj.bridge.IDwcjBBjBridge;

public final class Environment {
    private static final HashMap<Object, Environment> instanceMap = new HashMap();
    private final BBjAPI api;
    private final BBjSysGui sysgui;
    private final IDwcjBBjBridge helper;

    private Environment(BBjAPI api, IDwcjBBjBridge helper) throws BBjException {
        this.api = api;
        this.sysgui = api.openSysGui("X0");
        this.helper = helper;
    }

    public static void init(BBjAPI api, IDwcjBBjBridge helper) throws BBjException {
        Environment env = new Environment(api, helper);
        instanceMap.put(Thread.currentThread().getName(), env);
    }

    public static void cleanup() {
        instanceMap.remove(Thread.currentThread().getName());
    }

    public static Environment getInstance() {
        return instanceMap.get(Thread.currentThread().getName());
    }

    public BBjAPI getBBjAPI() {
        return this.api;
    }

    public BBjSysGui getSysGui() {
        return this.sysgui;
    }

    public IDwcjBBjBridge getDwcjHelper() {
        return this.helper;
    }

    public static void logError(String message, Exception e) {
        System.err.println(message);
        e.printStackTrace();
    }

    public static void logError(Exception e) {
        e.printStackTrace();
    }

    public static void logError(String message) {
        System.err.println(message);
    }
}

