/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.annotations;

import java.util.HashMap;
import org.dwcj.App;
import org.dwcj.annotations.AppAttribute;
import org.dwcj.annotations.AppDarkTheme;
import org.dwcj.annotations.AppLightTheme;
import org.dwcj.annotations.AppMeta;
import org.dwcj.annotations.AppTheme;
import org.dwcj.annotations.AppTitle;
import org.dwcj.annotations.Attribute;
import org.dwcj.annotations.InlineJavaScript;
import org.dwcj.annotations.InlineStyleSheet;
import org.dwcj.annotations.JavaScript;
import org.dwcj.annotations.Link;
import org.dwcj.annotations.StyleSheet;
import org.dwcj.controls.AbstractControl;
import org.dwcj.exceptions.DwcAnnotationException;
import org.dwcj.exceptions.DwcException;
import org.dwcj.util.Assets;

public final class AnnotationProcessor {
    public void processAppAnnotations(App app, RunningPhase phase) throws DwcAnnotationException {
        try {
            if (phase == RunningPhase.PRE_RUN) {
                this.processAppAttribute(app);
                this.processAppMeta(app);
                this.processLink(app);
                this.processStyleSheet(app);
                this.processInlineStyleSheet(app);
                this.processJavaScript(app);
                this.processInlineJavaScript(app);
                this.processAppDarkTheme(app);
                this.processAppLightTheme(app);
                this.processAppTheme(app);
            }
            if (phase == RunningPhase.POST_RUN) {
                this.processAppTitle(app);
            }
        }
        catch (DwcException e) {
            throw new DwcAnnotationException("Failed to process app annotations", e);
        }
    }

    public void processControlAnnotations(AbstractControl control) throws DwcAnnotationException {
        try {
            this.processLink(control);
            this.processStyleSheet(control);
            this.processInlineStyleSheet(control);
            this.processJavaScript(control);
            this.processInlineJavaScript(control);
        }
        catch (DwcException e) {
            throw new DwcAnnotationException("Failed to process control annotations", e);
        }
    }

    private void processAppTitle(Object clazz) throws DwcException {
        AppTitle appTitle = clazz.getClass().getAnnotation(AppTitle.class);
        if (appTitle != null) {
            App.setTitle(appTitle.value());
        }
    }

    private void processAppAttribute(Object clazz) throws DwcException {
        AppAttribute[] appAttributes = (AppAttribute[])clazz.getClass().getAnnotationsByType(AppAttribute.class);
        if (appAttributes != null) {
            for (AppAttribute appAttribute : appAttributes) {
                App.setAttribute(appAttribute.name(), appAttribute.value(), appAttribute.selector());
            }
        }
    }

    private void processAppDarkTheme(Object clazz) throws DwcException {
        AppDarkTheme appDarkTheme = clazz.getClass().getAnnotation(AppDarkTheme.class);
        if (appDarkTheme != null) {
            App.setDarkTheme(appDarkTheme.value());
        }
    }

    private void processAppLightTheme(Object clazz) throws DwcException {
        AppLightTheme appLightTheme = clazz.getClass().getAnnotation(AppLightTheme.class);
        if (appLightTheme != null) {
            App.setLightTheme(appLightTheme.value());
        }
    }

    private void processAppTheme(Object clazz) throws DwcException {
        AppTheme appTheme = clazz.getClass().getAnnotation(AppTheme.class);
        if (appTheme != null) {
            App.setTheme(appTheme.value());
        }
    }

    private void processAppMeta(Object clazz) throws DwcException {
        AppMeta[] appMeta = (AppMeta[])clazz.getClass().getAnnotationsByType(AppMeta.class);
        if (appMeta != null) {
            for (AppMeta meta : appMeta) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Attribute attribute : meta.attributes()) {
                    attributes.put(attribute.name(), attribute.value());
                }
                App.setMeta(meta.name(), meta.content(), attributes);
            }
        }
    }

    private void processStyleSheet(Object clazz) throws DwcException {
        StyleSheet[] styleSheet = (StyleSheet[])clazz.getClass().getAnnotationsByType(StyleSheet.class);
        if (styleSheet != null) {
            for (StyleSheet sheet : styleSheet) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Attribute attribute : sheet.attributes()) {
                    attributes.put(attribute.name(), attribute.value());
                }
                if (sheet.id() != null && !sheet.id().isEmpty()) {
                    attributes.put("id", sheet.id());
                }
                App.addStyleSheet(sheet.url(), sheet.top(), attributes);
            }
        }
    }

    private void processInlineStyleSheet(Object clazz) throws DwcException {
        InlineStyleSheet[] inlineStyleSheets = (InlineStyleSheet[])clazz.getClass().getAnnotationsByType(InlineStyleSheet.class);
        if (inlineStyleSheets != null) {
            for (InlineStyleSheet inlineStyleSheet : inlineStyleSheets) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Attribute attribute : inlineStyleSheet.attributes()) {
                    attributes.put(attribute.name(), attribute.value());
                }
                if (inlineStyleSheet.id() != null && !inlineStyleSheet.id().isEmpty()) {
                    attributes.put("id", inlineStyleSheet.id());
                }
                String content = inlineStyleSheet.value();
                if (inlineStyleSheet.local()) {
                    content = Assets.contentOf(content);
                }
                App.addInlineStyleSheet(content, inlineStyleSheet.top(), attributes);
            }
        }
    }

    private void processJavaScript(Object clazz) throws DwcException {
        JavaScript[] javaScript = (JavaScript[])clazz.getClass().getAnnotationsByType(JavaScript.class);
        if (javaScript != null) {
            for (JavaScript script : javaScript) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Attribute attribute : script.attributes()) {
                    attributes.put(attribute.name(), attribute.value());
                }
                if (script.id() != null && !script.id().isEmpty()) {
                    attributes.put("id", script.id());
                }
                App.addJavaScript(script.url(), script.top(), attributes);
            }
        }
    }

    private void processInlineJavaScript(Object clazz) throws DwcException {
        InlineJavaScript[] inlineJavaScripts = (InlineJavaScript[])clazz.getClass().getAnnotationsByType(InlineJavaScript.class);
        if (inlineJavaScripts != null) {
            for (InlineJavaScript inlineJavaScript : inlineJavaScripts) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Attribute attribute : inlineJavaScript.attributes()) {
                    attributes.put(attribute.name(), attribute.value());
                }
                String content = inlineJavaScript.value();
                if (inlineJavaScript.local()) {
                    content = Assets.contentOf(content);
                }
                App.addInlineJavaScript(content, inlineJavaScript.top(), attributes);
            }
        }
    }

    private void processLink(Object clazz) throws DwcException {
        Link[] links = (Link[])clazz.getClass().getAnnotationsByType(Link.class);
        if (links != null) {
            for (Link link : links) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Attribute attribute : link.attributes()) {
                    attributes.put(attribute.name(), attribute.value());
                }
                if (link.id() != null && !link.id().isEmpty()) {
                    attributes.put("id", link.id());
                }
                App.addLink(link.url(), link.top(), attributes);
            }
        }
    }

    public static enum RunningPhase {
        PRE_RUN,
        POST_RUN;

    }
}

