/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls;

import com.basis.startup.type.BBjException;
import com.basis.util.common.BasisNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dwcj.Environment;
import org.dwcj.controls.AbstractControl;
import org.dwcj.interfaces.Enableable;
import org.dwcj.interfaces.HasAttribute;
import org.dwcj.interfaces.HasClassName;
import org.dwcj.interfaces.HasComputedStyle;
import org.dwcj.interfaces.HasControlText;
import org.dwcj.interfaces.HasMouseWheelCondition;
import org.dwcj.interfaces.HasStyle;
import org.dwcj.interfaces.HasTooltip;
import org.dwcj.interfaces.HasVisibility;
import org.dwcj.interfaces.TextAlignable;
import org.dwcj.interfaces.TextHighlightable;

public abstract class AbstractDwcControl
extends AbstractControl
implements HasAttribute,
HasControlText,
HasComputedStyle,
HasClassName,
HasStyle,
Enableable,
HasTooltip,
HasVisibility {
    public static final String STR_EXPANSE = "expanse";
    public static final String STR_THEME = "theme";
    protected static final BasisNumber BASISNUMBER_1 = BasisNumber.createBasisNumber((Object)1);
    protected static final BasisNumber BASISNUMBER_25 = BasisNumber.createBasisNumber((Object)25);
    protected static final BasisNumber BASISNUMBER_250 = BasisNumber.createBasisNumber((Object)250);
    private String text = "";
    private Boolean visible = true;
    private Boolean enabled = true;
    private String tooltipText = "";
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<String> cssClasses = new ArrayList<String>();
    private final Map<String, String> styles = new HashMap<String, String>();
    private Enum<?> theme = null;
    private Enum<?> expanse = null;
    protected Boolean readOnly = null;
    protected Boolean focusable = null;
    protected Boolean tabTraversable = null;
    protected TextAlignable.Alignment textAlignment = null;
    protected Integer horizontalScrollBarPosition = null;
    protected Integer verticalScrollBarPosition = null;
    protected HasMouseWheelCondition.MouseWheelCondition mouseWheelCondition = null;
    protected TextHighlightable.Highlight textHighlight = null;

    @Override
    public String getAttribute(String attribute) {
        if (this.ctrl != null) {
            try {
                return this.ctrl.getAttribute(attribute);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.attributes.get(attribute);
    }

    @Override
    public AbstractDwcControl setAttribute(String attribute, String value) {
        if (this.ctrl != null) {
            try {
                this.ctrl.setAttribute(attribute, value);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.attributes.put(attribute, value);
        return this;
    }

    @Override
    public String getText() {
        if (this.ctrl != null) {
            try {
                return this.ctrl.getText();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.text;
    }

    @Override
    public AbstractDwcControl setText(String text) {
        if (this.ctrl != null) {
            try {
                this.ctrl.setText(text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.text = text != null ? new String(text.getBytes()) : "<null>";
        return this;
    }

    @Override
    public String getComputedStyle(String property) {
        if (this.ctrl != null) {
            try {
                return this.ctrl.getComputedStyle(property);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return "";
    }

    @Override
    public AbstractDwcControl addClassName(String selector) {
        if (this.ctrl != null) {
            try {
                this.ctrl.addStyle(selector);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.cssClasses.add(selector);
        return this;
    }

    @Override
    public AbstractDwcControl removeClassName(String selector) {
        if (this.ctrl != null) {
            try {
                this.ctrl.removeStyle(selector);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.cssClasses.remove(selector);
        return this;
    }

    @Override
    public AbstractDwcControl setStyle(String property, String value) {
        if (this.ctrl != null) {
            try {
                this.ctrl.setStyle(property, value);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.styles.put(property, value);
        return this;
    }

    @Override
    public Boolean isEnabled() {
        if (this.ctrl != null) {
            try {
                return this.ctrl.isEnabled();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.enabled;
    }

    @Override
    public AbstractDwcControl setEnabled(Boolean enabled) {
        if (this.ctrl != null) {
            try {
                this.ctrl.setEnabled(enabled.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.enabled = enabled;
        return this;
    }

    @Override
    public String getTooltipText() {
        if (this.ctrl != null) {
            try {
                return this.ctrl.getToolTipText();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tooltipText;
    }

    @Override
    public AbstractDwcControl setTooltipText(String text) {
        if (this.ctrl != null) {
            try {
                this.ctrl.setToolTipText(text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tooltipText = text;
        return this;
    }

    @Override
    public Boolean isVisible() {
        if (this.ctrl != null) {
            try {
                return this.ctrl.isVisible();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.visible;
    }

    @Override
    public AbstractDwcControl setVisible(Boolean visible) {
        if (this.ctrl != null) {
            try {
                this.ctrl.setVisible(visible.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.visible = visible;
        return this;
    }

    protected void setControlTheme(Enum<?> theme) {
        if (this.ctrl != null) {
            try {
                switch (theme.toString()) {
                    case "DEFAULT": {
                        this.ctrl.setAttribute(STR_THEME, "default");
                        break;
                    }
                    case "DANGER": {
                        this.ctrl.setAttribute(STR_THEME, "danger");
                        break;
                    }
                    case "GRAY": {
                        this.ctrl.setAttribute(STR_THEME, "gray");
                        break;
                    }
                    case "INFO": {
                        this.ctrl.setAttribute(STR_THEME, "info");
                        break;
                    }
                    case "PRIMARY": {
                        this.ctrl.setAttribute(STR_THEME, "primary");
                        break;
                    }
                    case "SUCCESS": {
                        this.ctrl.setAttribute(STR_THEME, "success");
                        break;
                    }
                    case "WARNING": {
                        this.ctrl.setAttribute(STR_THEME, "warning");
                        break;
                    }
                    case "OUTLINED_DANGER": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-danger");
                        break;
                    }
                    case "OUTLINED_DEFAULT": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-default");
                        break;
                    }
                    case "OUTLINED_GRAY": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-gray");
                        break;
                    }
                    case "OUTLINED_INFO": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-info");
                        break;
                    }
                    case "OUTLINED_SUCCESS": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-success");
                        break;
                    }
                    case "OUTLINED_WARNING": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-warning");
                        break;
                    }
                    case "OUTLINED_PRIMARY": {
                        this.ctrl.setAttribute(STR_THEME, "outlined-primary");
                        break;
                    }
                }
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.theme = theme;
    }

    protected void setControlExpanse(Enum<?> expanse) {
        if (this.ctrl != null) {
            try {
                switch (expanse.toString()) {
                    case "LARGE": {
                        this.ctrl.setAttribute(STR_EXPANSE, "l");
                        break;
                    }
                    case "MEDIUM": {
                        this.ctrl.setAttribute(STR_EXPANSE, "m");
                        break;
                    }
                    case "SMALL": {
                        this.ctrl.setAttribute(STR_EXPANSE, "s");
                        break;
                    }
                    case "XLARGE": {
                        this.ctrl.setAttribute(STR_EXPANSE, "xl");
                        break;
                    }
                    case "XSMALL": {
                        this.ctrl.setAttribute(STR_EXPANSE, "xs");
                        break;
                    }
                    case "XXSMALL": {
                        this.ctrl.setAttribute(STR_EXPANSE, "xxs");
                        break;
                    }
                    case "XXXSMALL": {
                        this.ctrl.setAttribute(STR_EXPANSE, "xxxs");
                        break;
                    }
                }
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.expanse = expanse;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (!this.text.isEmpty()) {
            try {
                this.ctrl.setText(this.text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        if (!Boolean.TRUE.equals(this.visible)) {
            this.setVisible(this.visible);
        }
        if (!Boolean.TRUE.equals(this.enabled)) {
            this.setEnabled(this.enabled);
        }
        if (!this.tooltipText.isEmpty()) {
            try {
                this.ctrl.setToolTipText(this.tooltipText);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        if (!this.attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (!this.styles.isEmpty()) {
            for (Map.Entry entry : this.styles.entrySet()) {
                this.setStyle((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!this.cssClasses.isEmpty()) {
            for (String string : this.cssClasses) {
                this.addClassName(string);
            }
        }
        if (!this.userData.isEmpty()) {
            for (String string : this.cssClasses) {
                this.setUserData(string, this.userData.get(string));
            }
        }
        if (this.theme != null) {
            this.setControlTheme(this.theme);
        }
        if (this.expanse != null) {
            this.setControlExpanse(this.expanse);
        }
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        try {
            if (this.ctrl != null && !this.ctrl.isDestroyed()) {
                this.ctrl.destroy();
            }
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
    }
}

