/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.button;

import com.basis.bbj.proxies.sysgui.BBjButton;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.button.events.ButtonClickEvent;
import org.dwcj.controls.button.sinks.ButtonClickEventSink;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.interfaces.TextAlignable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class Button
extends AbstractDwcControl
implements Focusable,
TabTraversable,
TextAlignable {
    private ArrayList<Consumer<ButtonClickEvent>> callbacks = new ArrayList();
    private ButtonClickEventSink buttonClickEventSink;
    private Boolean disableOnClick = false;
    private Expanse expanse = null;
    private Theme theme = Theme.DEFAULT;
    private TextVerticalAlignment verticalAlignment = TextVerticalAlignment.CENTER;

    public Button() {
        this("");
    }

    public Button(String text) {
        super.setText(text);
        this.focusable = true;
        this.tabTraversable = true;
        this.textAlignment = TextAlignable.Alignment.MIDDLE;
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addButton(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, super.getText(), flags);
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public Button onClick(Consumer<ButtonClickEvent> callback) {
        if (this.ctrl != null) {
            if (this.buttonClickEventSink == null) {
                this.buttonClickEventSink = new ButtonClickEventSink(this);
            }
            this.buttonClickEventSink.addCallback(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public Boolean isDisableOnClick() {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).getDisableOnClick();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.disableOnClick;
    }

    public Button setDisableOnClick(Boolean disable) {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).setDisableOnClick(disable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.disableOnClick = disable;
        return this;
    }

    public TextVerticalAlignment getVerticalAlignment() {
        if (this.ctrl != null) {
            return this.verticalAlignment;
        }
        return this.verticalAlignment;
    }

    public Button setVerticalAlignment(TextVerticalAlignment alignment) {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).setVerticalAlignment(alignment.alignment.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.verticalAlignment = alignment;
        return this;
    }

    @Override
    public Button setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public Button setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public Button setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public Button setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public Button setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public Button setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public Button setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public Button addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public Button removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public Expanse getExpanse() {
        return this.expanse;
    }

    public Button setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public Button setTheme(Theme theme) {
        super.setControlTheme(theme);
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public Button setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public Button setTabTraversable(Boolean traversable) {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).setTabTraversable(traversable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traversable;
        return this;
    }

    @Override
    public TextAlignable.Alignment getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public Button setTextAlignment(TextAlignable.Alignment alignment) {
        if (this.ctrl != null) {
            try {
                ((BBjButton)this.ctrl).setAlignment(alignment.textPosition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textAlignment = alignment;
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (Boolean.TRUE.equals(this.disableOnClick)) {
            this.setDisableOnClick(this.disableOnClick);
        }
        if (!this.callbacks.isEmpty()) {
            this.buttonClickEventSink = new ButtonClickEventSink(this);
            while (!this.callbacks.isEmpty()) {
                this.buttonClickEventSink.addCallback(this.callbacks.remove(0));
            }
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
        if (this.textAlignment != TextAlignable.Alignment.MIDDLE) {
            this.setTextAlignment(this.textAlignment);
        }
        if (this.expanse != null) {
            this.setExpanse(this.expanse);
        }
        if (this.theme != Theme.DEFAULT) {
            this.setTheme(this.theme);
        }
    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        PRIMARY,
        SUCCESS,
        WARNING,
        OUTLINED_DANGER,
        OUTLINED_DEFAULT,
        OUTLINED_GRAY,
        OUTLINED_INFO,
        OUTLINED_SUCCESS,
        OUTLINED_PRIMARY,
        OUTLINED_WARNING;

    }

    public static enum TextVerticalAlignment {
        TOP(1),
        CENTER(0),
        BOTTOM(3);

        public final Integer alignment;

        private TextVerticalAlignment(Integer alignment) {
            this.alignment = alignment;
        }
    }
}

