/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.button.sinks;

import com.basis.bbj.proxies.event.BBjButtonPushEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.button.Button;
import org.dwcj.controls.button.events.ButtonClickEvent;

public final class ButtonClickEventSink {
    private ArrayList<Consumer<ButtonClickEvent>> targets = new ArrayList();
    private final Button button;

    public ButtonClickEventSink(Button btn) {
        this.button = btn;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(btn);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(2, Environment.getInstance().getDwcjHelper().getEventProxy(this, "pushEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ButtonClickEventSink(Button btn, Consumer<ButtonClickEvent> callback) {
        this.targets.add(callback);
        this.button = btn;
        BBjControl bbjctrl = null;
        try {
            bbjctrl = ControlAccessor.getDefault().getBBjControl(btn);
            Environment.getInstance().getBBjAPI();
            bbjctrl.setCallback(2, Environment.getInstance().getDwcjHelper().getEventProxy(this, "pushEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void pushEvent(BBjButtonPushEvent ev) {
        ButtonClickEvent dwcEv = new ButtonClickEvent(this.button);
        Iterator<Consumer<ButtonClickEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void doClick() {
        ButtonClickEvent dwcEv = new ButtonClickEvent(this.button);
        Iterator<Consumer<ButtonClickEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ButtonClickEvent> callback) {
        this.targets.add(callback);
    }
}

