/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.checkbox;

import com.basis.bbj.proxies.sysgui.BBjCheckBox;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.AbstractDwcControl;
import org.dwcj.controls.checkbox.events.CheckBoxChangeEvent;
import org.dwcj.controls.checkbox.sinks.CheckBoxCheckEventSink;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.HasReadOnly;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.interfaces.TextAlignable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class CheckBox
extends AbstractDwcControl
implements HasReadOnly,
Focusable,
TabTraversable,
TextAlignable {
    private ArrayList<Consumer<CheckBoxChangeEvent>> callbacks = new ArrayList();
    private CheckBoxCheckEventSink checkboxCheckEventSink;
    private HorizontalTextPosition horizontalTextPosition = HorizontalTextPosition.RIGHT;
    private Boolean checked = false;

    public CheckBox() {
        this.readOnly = false;
        this.focusable = true;
        this.tabTraversable = true;
        this.textAlignment = TextAlignable.Alignment.LEFT;
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addCheckBox(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, "", flags);
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public CheckBox onChange(Consumer<CheckBoxChangeEvent> callback) {
        if (this.ctrl != null) {
            if (this.checkboxCheckEventSink == null) {
                this.checkboxCheckEventSink = new CheckBoxCheckEventSink(this);
            }
            this.checkboxCheckEventSink.addCallback(callback);
        } else {
            this.callbacks.add(callback);
        }
        return this;
    }

    public HorizontalTextPosition getHorizontalTextPosition() {
        if (this.ctrl != null) {
            return this.horizontalTextPosition;
        }
        return HorizontalTextPosition.RIGHT;
    }

    public CheckBox setHorizontalTextPosition(HorizontalTextPosition position) {
        if (this.ctrl != null) {
            try {
                ((BBjCheckBox)this.ctrl).setHorizontalTextPosition(position.position.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.horizontalTextPosition = position;
        return this;
    }

    public Boolean isChecked() {
        if (this.ctrl != null) {
            try {
                return ((BBjCheckBox)this.ctrl).isSelected();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return false;
    }

    public CheckBox setChecked(Boolean checked) {
        if (this.ctrl != null) {
            try {
                ((BBjCheckBox)this.ctrl).setSelected(checked.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.checked = checked;
        return this;
    }

    @Override
    public CheckBox setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public CheckBox setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public CheckBox setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public CheckBox setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public CheckBox setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public CheckBox setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public CheckBox setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public CheckBox addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public CheckBox removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public CheckBox setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.ctrl != null) {
            try {
                return !((BBjCheckBox)this.ctrl).isEditable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.readOnly;
    }

    @Override
    public CheckBox setReadOnly(Boolean editable) {
        if (this.ctrl != null) {
            try {
                ((BBjCheckBox)this.ctrl).setEditable(editable == false);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.readOnly = editable;
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                return ((BBjCheckBox)this.ctrl).isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public CheckBox setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                ((BBjCheckBox)this.ctrl).setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                return ((BBjCheckBox)this.ctrl).isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public CheckBox setTabTraversable(Boolean traversable) {
        if (this.ctrl != null) {
            try {
                ((BBjCheckBox)this.ctrl).setTabTraversable(traversable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traversable;
        return this;
    }

    @Override
    public TextAlignable.Alignment getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public CheckBox setTextAlignment(TextAlignable.Alignment alignment) {
        if (this.ctrl != null) {
            try {
                ((BBjCheckBox)this.ctrl).setAlignment(alignment.textPosition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textAlignment = alignment;
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (this.checked != null) {
            this.setChecked(this.checked);
        }
        if (!this.callbacks.isEmpty()) {
            this.checkboxCheckEventSink = new CheckBoxCheckEventSink(this);
            while (!this.callbacks.isEmpty()) {
                this.checkboxCheckEventSink.addCallback(this.callbacks.remove(0));
            }
        }
        if (this.horizontalTextPosition != HorizontalTextPosition.RIGHT) {
            try {
                ((BBjCheckBox)this.ctrl).setHorizontalTextPosition(this.horizontalTextPosition.position.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
            this.setHorizontalTextPosition(this.horizontalTextPosition);
        }
        if (Boolean.TRUE.equals(this.readOnly)) {
            this.setReadOnly(true);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
        if (this.textAlignment != TextAlignable.Alignment.LEFT) {
            this.setTextAlignment(this.textAlignment);
        }
    }

    public static enum HorizontalTextPosition {
        RIGHT(4),
        LEFT(2),
        CENTER(0),
        LEADING(10),
        TRAILING(11);

        public final Integer position;

        private HorizontalTextPosition(Integer position) {
            this.position = position;
        }
    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

