/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.checkbox.sinks;

import com.basis.bbj.proxies.event.BBjCheckOffEvent;
import com.basis.bbj.proxies.event.BBjCheckOnEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.checkbox.CheckBox;
import org.dwcj.controls.checkbox.events.CheckBoxChangeEvent;

public final class CheckBoxCheckEventSink {
    private final ArrayList<Consumer<CheckBoxChangeEvent>> targets = new ArrayList();
    private final CheckBox checkBox;
    private BBjControl bbjctrl;
    private static final String ON_EVENT = "onEvent";

    public CheckBoxCheckEventSink(CheckBox cb) {
        this.checkBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(26, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOffEvent"), ON_EVENT);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(25, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOnEvent"), ON_EVENT);
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public CheckBoxCheckEventSink(CheckBox cb, Consumer<CheckBoxChangeEvent> target) {
        this.targets.add(target);
        this.checkBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(26, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOffEvent"), ON_EVENT);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(25, Environment.getInstance().getDwcjHelper().getEventProxy(this, "checkOnEvent"), ON_EVENT);
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void checkOffEvent(BBjCheckOffEvent ev) {
        CheckBoxChangeEvent dwcEv = new CheckBoxChangeEvent(this.checkBox, false);
        Iterator<Consumer<CheckBoxChangeEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void checkOnEvent(BBjCheckOnEvent ev) {
        CheckBoxChangeEvent dwcEv = new CheckBoxChangeEvent(this.checkBox, true);
        Iterator<Consumer<CheckBoxChangeEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<CheckBoxChangeEvent> callback) {
        this.targets.add(callback);
    }
}

