/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.combobox;

import com.basis.bbj.proxies.sysgui.BBjListButton;
import com.basis.bbj.proxies.sysgui.BBjWindow;
import com.basis.startup.type.BBjException;
import com.basis.startup.type.BBjNumber;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.PanelAccessor;
import org.dwcj.controls.combobox.events.ComboBoxChangeEvent;
import org.dwcj.controls.combobox.events.ComboBoxCloseEvent;
import org.dwcj.controls.combobox.events.ComboBoxOpenEvent;
import org.dwcj.controls.combobox.events.ComboBoxSelectEvent;
import org.dwcj.controls.combobox.sinks.ComboBoxChangeEventSink;
import org.dwcj.controls.combobox.sinks.ComboBoxCloseEventSink;
import org.dwcj.controls.combobox.sinks.ComboBoxOpenEventSink;
import org.dwcj.controls.combobox.sinks.ComboBoxSelectEventSink;
import org.dwcj.controls.listbox.AbstractDwclistControl;
import org.dwcj.controls.panels.AbstractDwcjPanel;
import org.dwcj.interfaces.Focusable;
import org.dwcj.interfaces.HasReadOnly;
import org.dwcj.interfaces.TabTraversable;
import org.dwcj.interfaces.TextAlignable;
import org.dwcj.util.BBjFunctionalityHelper;

public final class ComboBox
extends AbstractDwclistControl
implements HasReadOnly,
Focusable,
TabTraversable,
TextAlignable {
    private BBjListButton bbjListButton;
    private ArrayList<Consumer<ComboBoxChangeEvent>> changeEvents = new ArrayList();
    private ComboBoxChangeEventSink changeEventSink;
    private ArrayList<Consumer<ComboBoxSelectEvent>> selectEvents = new ArrayList();
    private ComboBoxSelectEventSink selectEventSink;
    private ArrayList<Consumer<ComboBoxOpenEvent>> openEvents = new ArrayList();
    private ComboBoxOpenEventSink openEventSink;
    private ArrayList<Consumer<ComboBoxCloseEvent>> closeEvents = new ArrayList();
    private ComboBoxCloseEventSink closeEventSink;
    private Integer maxRowCount;
    private AbstractMap.SimpleEntry<Integer, String> textAt = null;

    public ComboBox() {
        this.readOnly = false;
        this.focusable = true;
        this.tabTraversable = true;
        this.textAlignment = TextAlignable.Alignment.LEFT;
    }

    @Override
    protected void create(AbstractDwcjPanel p) {
        try {
            BBjWindow w = PanelAccessor.getDefault().getBBjWindow(p);
            byte[] flags = BBjFunctionalityHelper.buildStandardCreationFlags(this.isVisible(), this.isEnabled());
            this.ctrl = w.addListButton(w.getAvailableControlID(), (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_1, (BBjNumber)BASISNUMBER_250, (BBjNumber)BASISNUMBER_250, "", flags);
            this.ctrl.setAttribute("max-row-count", "25");
            this.ctrl.setAttribute("open-width", "2500");
            this.ctrl.setAttribute("button-height", "auto");
            this.ctrl.setAttribute("left", "calc( 50vw - 100px )");
            this.bbjListButton = (BBjListButton)this.ctrl;
            this.populate();
            this.catchUp();
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ComboBox addItem(Object key, String item) {
        this.values.put(key, item);
        this.data2.add(this.values.get(key));
        this.populate();
        return this;
    }

    public ComboBox insertItemAt(Object key, String item, Integer index) {
        this.values.put(key, item);
        this.data2.add(index.intValue(), this.values.get(key));
        this.populate();
        return this;
    }

    public ComboBox addItems(Map<Object, String> items) {
        this.values.putAll(items);
        Iterator<Object> it = items.keySet().iterator();
        while (it.hasNext()) {
            this.data2.add(this.values.get(it.next()));
        }
        this.populate();
        return this;
    }

    public ComboBox insertItemsAt(Map<Object, String> items, Integer index) {
        this.values.putAll(items);
        Iterator<Object> it = items.keySet().iterator();
        Integer counter = 0;
        while (it.hasNext()) {
            Integer n = counter;
            counter = counter + 1;
            this.data2.add(index + n, this.values.get(it.next()));
        }
        this.populate();
        return this;
    }

    @Override
    protected void populate() {
        if (this.ctrl != null) {
            try {
                BBjListButton cb = (BBjListButton)this.ctrl;
                cb.removeAllItems();
                cb.insertItems(0, this.data2);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
    }

    public ComboBox setItems(Map<Object, String> values) {
        this.values = values;
        this.data2.clear();
        Iterator<Object> it = values.keySet().iterator();
        while (it.hasNext()) {
            this.data2.add((Object)values.get(it.next()));
        }
        this.populate();
        return this;
    }

    public ComboBox deselect() {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).deselect();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public Map<Object, String> getAllItems() {
        return this.values;
    }

    public String getItem(Object key) {
        return (String)this.values.get(key);
    }

    public String getItemAt(Integer idx) {
        if (this.ctrl != null) {
            try {
                BBjListButton cb = (BBjListButton)this.ctrl;
                return cb.getItemAt(idx.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public Integer getSelectedIndex() {
        if (this.ctrl != null) {
            try {
                return ((BBjListButton)this.ctrl).getSelectedIndex();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public AbstractMap.SimpleEntry<Object, String> getSelectedItem() {
        try {
            String value = this.bbjListButton.getSelectedItem();
            for (Map.Entry entry : this.values.entrySet()) {
                if (!Objects.equals(value, entry.getValue())) continue;
                return new AbstractMap.SimpleEntry<Object, String>(entry.getKey(), value);
            }
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        return new AbstractMap.SimpleEntry<Object, Object>(null, null);
    }

    public Integer getItemCount() {
        if (this.ctrl != null) {
            try {
                return ((BBjListButton)this.ctrl).getItemCount();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return null;
    }

    public ComboBox open() {
        try {
            this.bbjListButton.openList();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        return this;
    }

    public ComboBox close() {
        try {
            this.bbjListButton.closeList();
        }
        catch (BBjException e) {
            Environment.logError((Exception)((Object)e));
        }
        return this;
    }

    public ComboBox onSelect(Consumer<ComboBoxSelectEvent> callback) {
        if (this.ctrl != null) {
            if (this.selectEventSink == null) {
                this.selectEventSink = new ComboBoxSelectEventSink(this);
            }
            this.selectEventSink.addCallback(callback);
        } else {
            this.selectEvents.add(callback);
        }
        return this;
    }

    public ComboBox onOpen(Consumer<ComboBoxOpenEvent> callback) {
        if (this.ctrl != null) {
            if (this.openEventSink == null) {
                this.openEventSink = new ComboBoxOpenEventSink(this);
            }
            this.openEventSink.addCallback(callback);
        } else {
            this.openEvents.add(callback);
        }
        return this;
    }

    public ComboBox onClose(Consumer<ComboBoxCloseEvent> callback) {
        if (this.ctrl != null) {
            if (this.closeEventSink == null) {
                this.closeEventSink = new ComboBoxCloseEventSink(this);
            }
            this.closeEventSink.addCallback(callback);
        } else {
            this.closeEvents.add(callback);
        }
        return this;
    }

    public ComboBox removeAllItems() {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).removeAllItems();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ComboBox removeItemAt(Integer index) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).removeItemAt(index.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ComboBox selectIndex(Integer index) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).selectIndex(index.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    public ComboBox setMaximumRowCount(Integer max) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).setMaximumRowCount(max.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.maxRowCount = max;
        return this;
    }

    public ComboBox setTextAt(Integer idx, String text) {
        this.textAt = new AbstractMap.SimpleEntry<Integer, String>(idx, text);
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).setTextAt(idx.intValue(), text);
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.ctrl != null) {
            try {
                return !((BBjListButton)this.ctrl).isEditable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.readOnly;
    }

    @Override
    public ComboBox setReadOnly(Boolean readOnly) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).setEditable(readOnly.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public Boolean isFocusable() {
        if (this.ctrl != null) {
            try {
                return ((BBjListButton)this.ctrl).isFocusable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.focusable;
    }

    @Override
    public ComboBox setFocusable(Boolean focusable) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).setFocusable(focusable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.focusable = focusable;
        return this;
    }

    @Override
    public Boolean isTabTraversable() {
        if (this.ctrl != null) {
            try {
                return ((BBjListButton)this.ctrl).isTabTraversable();
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        return this.tabTraversable;
    }

    @Override
    public ComboBox setTabTraversable(Boolean traversable) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).setTabTraversable(traversable.booleanValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.tabTraversable = traversable;
        return this;
    }

    @Override
    public TextAlignable.Alignment getTextAlignment() {
        return this.textAlignment;
    }

    @Override
    public ComboBox setTextAlignment(TextAlignable.Alignment textAlignment) {
        if (this.ctrl != null) {
            try {
                ((BBjListButton)this.ctrl).setAlignment(textAlignment.textPosition.intValue());
            }
            catch (BBjException e) {
                Environment.logError((Exception)((Object)e));
            }
        }
        this.textAlignment = textAlignment;
        return this;
    }

    @Override
    public ComboBox setText(String text) {
        super.setText(text);
        return this;
    }

    @Override
    public ComboBox setVisible(Boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public ComboBox setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public ComboBox setTooltipText(String text) {
        super.setTooltipText(text);
        return this;
    }

    @Override
    public ComboBox setAttribute(String attribute, String value) {
        super.setAttribute(attribute, value);
        return this;
    }

    @Override
    public ComboBox setId(String elementId) {
        super.setId(elementId);
        return this;
    }

    @Override
    public ComboBox setStyle(String property, String value) {
        super.setStyle(property, value);
        return this;
    }

    @Override
    public ComboBox addClassName(String selector) {
        super.addClassName(selector);
        return this;
    }

    @Override
    public ComboBox removeClassName(String selector) {
        super.removeClassName(selector);
        return this;
    }

    public ComboBox setExpanse(Expanse expanse) {
        super.setControlExpanse(expanse);
        return this;
    }

    @Override
    protected void catchUp() throws IllegalAccessException {
        if (Boolean.TRUE.equals(this.getCaughtUp())) {
            throw new IllegalAccessException("catchUp cannot be called twice");
        }
        super.catchUp();
        if (this.maxRowCount != null) {
            this.setMaximumRowCount(this.maxRowCount);
        }
        if (this.textAt != null) {
            this.setTextAt(this.textAt.getKey(), this.textAt.getValue());
        }
        if (!this.changeEvents.isEmpty()) {
            this.changeEventSink = new ComboBoxChangeEventSink(this);
            while (!this.changeEvents.isEmpty()) {
                this.changeEventSink.addCallback(this.changeEvents.remove(0));
            }
        }
        if (!this.selectEvents.isEmpty()) {
            this.selectEventSink = new ComboBoxSelectEventSink(this);
            while (!this.selectEvents.isEmpty()) {
                this.selectEventSink.addCallback(this.selectEvents.remove(0));
            }
        }
        if (!this.openEvents.isEmpty()) {
            this.openEventSink = new ComboBoxOpenEventSink(this);
            while (!this.openEvents.isEmpty()) {
                this.openEventSink.addCallback(this.openEvents.remove(0));
            }
        }
        if (!this.closeEvents.isEmpty()) {
            this.closeEventSink = new ComboBoxCloseEventSink(this);
            while (!this.closeEvents.isEmpty()) {
                this.closeEventSink.addCallback(this.closeEvents.remove(0));
            }
        }
        if (this.maxRowCount != null) {
            this.setMaximumRowCount(this.maxRowCount);
        }
        if (Boolean.TRUE.equals(this.readOnly)) {
            this.setReadOnly(this.readOnly);
        }
        if (Boolean.FALSE.equals(this.focusable)) {
            this.setFocusable(this.focusable);
        }
        if (Boolean.FALSE.equals(this.tabTraversable)) {
            this.setTabTraversable(this.tabTraversable);
        }
        if (this.textAlignment != TextAlignable.Alignment.LEFT) {
            this.setTextAlignment(this.textAlignment);
        }
    }

    public static enum Theme {
        DEFAULT,
        DANGER,
        GRAY,
        INFO,
        PRIMARY,
        SUCCESS,
        WARNING,
        OUTLINED_DANGER,
        OUTLINED_DEFAULT,
        OUTLINED_GRAY,
        OUTLINED_INFO,
        OUTLINED_SUCCESS;

    }

    public static enum Expanse {
        LARGE,
        MEDIUM,
        SMALL,
        XLARGE,
        XSMALL;

    }
}

