/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.combobox.sinks;

import com.basis.bbj.proxies.event.BBjListCloseEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.combobox.ComboBox;
import org.dwcj.controls.combobox.events.ComboBoxCloseEvent;

public class ComboBoxCloseEventSink {
    private ArrayList<Consumer<ComboBoxCloseEvent>> targets = new ArrayList();
    private final ComboBox comboBox;
    private BBjControl bbjctrl;

    public ComboBoxCloseEventSink(ComboBox cb) {
        this.comboBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(21, Environment.getInstance().getDwcjHelper().getEventProxy(this, "closeEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ComboBoxCloseEventSink(ComboBox cb, Consumer<ComboBoxCloseEvent> callback) {
        this.targets.add(callback);
        this.comboBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(21, Environment.getInstance().getDwcjHelper().getEventProxy(this, "closeEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void closeEvent(BBjListCloseEvent ev) {
        ComboBoxCloseEvent dwcEv = new ComboBoxCloseEvent(this.comboBox);
        Iterator<Consumer<ComboBoxCloseEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ComboBoxCloseEvent> callback) {
        this.targets.add(callback);
    }
}

