/*
 * Decompiled with CFR 0.152.
 */
package org.dwcj.controls.combobox.sinks;

import com.basis.bbj.proxies.event.BBjListOpenEvent;
import com.basis.bbj.proxies.sysgui.BBjControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.dwcj.Environment;
import org.dwcj.bridge.ControlAccessor;
import org.dwcj.controls.combobox.ComboBox;
import org.dwcj.controls.combobox.events.ComboBoxOpenEvent;

public class ComboBoxOpenEventSink {
    private ArrayList<Consumer<ComboBoxOpenEvent>> targets = new ArrayList();
    private final ComboBox comboBox;
    private BBjControl bbjctrl;

    public ComboBoxOpenEventSink(ComboBox cb) {
        this.comboBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(20, Environment.getInstance().getDwcjHelper().getEventProxy(this, "openEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public ComboBoxOpenEventSink(ComboBox cb, Consumer<ComboBoxOpenEvent> callback) {
        this.targets.add(callback);
        this.comboBox = cb;
        try {
            this.bbjctrl = ControlAccessor.getDefault().getBBjControl(cb);
            Environment.getInstance().getBBjAPI();
            this.bbjctrl.setCallback(20, Environment.getInstance().getDwcjHelper().getEventProxy(this, "openEvent"), "onEvent");
        }
        catch (Exception e) {
            Environment.logError(e);
        }
    }

    public void openEvent(BBjListOpenEvent ev) {
        ComboBoxOpenEvent dwcEv = new ComboBoxOpenEvent(this.comboBox);
        Iterator<Consumer<ComboBoxOpenEvent>> it = this.targets.iterator();
        while (it.hasNext()) {
            it.next().accept(dwcEv);
        }
    }

    public void addCallback(Consumer<ComboBoxOpenEvent> callback) {
        this.targets.add(callback);
    }
}

